"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PushImageProject = void 0;
const core_1 = require("@aws-cdk/core");
const aws_codebuild_1 = require("@aws-cdk/aws-codebuild");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const build_spec_generator_1 = require("./build-spec-generator");
class PushImageProject extends aws_codebuild_1.PipelineProject {
    constructor(scope, id, props) {
        const { account, region } = core_1.Stack.of(scope);
        super(scope, id, {
            projectName: props.projectName,
            cache: props.cache ||
                aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER, aws_codebuild_1.LocalCacheMode.CUSTOM),
            buildSpec: props.buildSpec ||
                aws_codebuild_1.BuildSpec.fromObject(build_spec_generator_1.BuildSpecGenerator.default({ account, region }).render()),
            environment: {
                buildImage: aws_codebuild_1.LinuxBuildImage.STANDARD_4_0,
                computeType: props.computeType || aws_codebuild_1.ComputeType.SMALL,
                privileged: true,
                environmentVariables: {
                    AWS_ACCOUNT_ID: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: account,
                    },
                    EXECUTION_ROLE_ARN: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: props.taskDefinition.executionRole.roleArn,
                    },
                    FAMILY: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: props.taskDefinition.family,
                    },
                    REPOSITORY_URI: {
                        type: aws_codebuild_1.BuildEnvironmentVariableType.PLAINTEXT,
                        value: props.imageRepository.repositoryUri,
                    },
                    ...props.environmentVariables,
                },
            },
        });
        this.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: [
                'ecr:GetDownloadUrlForLayer',
                'ecr:BatchGetImage',
                'ecr:BatchCheckLayerAvailability',
                'ecr:PutImage',
                'ecr:InitiateLayerUpload',
                'ecr:UploadLayerPart',
                'ecr:CompleteLayerUpload',
            ],
            resources: [props.imageRepository.repositoryArn],
        }));
    }
}
exports.PushImageProject = PushImageProject;
//# sourceMappingURL=data:application/json;base64,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