import { Construct } from '@aws-cdk/core';
import { IConnectable, Connections, SecurityGroup } from '@aws-cdk/aws-ec2';
import { ITargetGroup } from '@aws-cdk/aws-elasticloadbalancingv2';
import { ICluster, LaunchType } from '@aws-cdk/aws-ecs';
import { DummyTaskDefinition } from './dummy-task-definition';
export declare enum SchedulingStrategy {
    REPLICA = "REPLICA",
    DAEMON = "DAEMON"
}
export interface BlueGreenServiceProps {
    securityGroups?: SecurityGroup[];
    cluster: ICluster;
    serviceName: string;
    launchType?: LaunchType;
    platformVersion?: string;
    desiredCount?: number;
    containerPort?: number;
    prodTargetGroup: ITargetGroup;
    taskDefinition: DummyTaskDefinition;
}
export declare class BlueGreenService extends Construct implements IConnectable {
    readonly serviceName: string;
    readonly connections: Connections;
    constructor(parent: Construct, id: string, props: BlueGreenServiceProps);
}
