"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const nodeunit_shim_1 = require("nodeunit-shim");
const lib_1 = require("../lib");
// tslint:disable:object-literal-key-quotes
nodeunit_shim_1.nodeunitShim({
    'Origin Access Identity with automatic comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, 'OAI');
        assert_1.expect(stack).toMatch({
            'Resources': {
                'OAIE1EFC67F': {
                    'Type': 'AWS::CloudFront::CloudFrontOriginAccessIdentity',
                    'Properties': {
                        'CloudFrontOriginAccessIdentityConfig': {
                            'Comment': 'Allows CloudFront to reach the bucket',
                        },
                    },
                },
            },
        });
        test.done();
    },
    'Origin Access Identity with comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, 'OAI', {
            comment: 'test comment',
        });
        assert_1.expect(stack).toMatch({
            'Resources': {
                'OAIE1EFC67F': {
                    'Type': 'AWS::CloudFront::CloudFrontOriginAccessIdentity',
                    'Properties': {
                        'CloudFrontOriginAccessIdentityConfig': {
                            'Comment': 'test comment',
                        },
                    },
                },
            },
        });
        test.done();
    },
    'Builds ARN of CloudFront user'(test) {
        const stack = new cdk.Stack();
        const oai = lib_1.OriginAccessIdentity.fromOriginAccessIdentityName(stack, 'OAI', 'OAITest');
        test.ok(oai.grantPrincipal.policyFragment.principalJson.AWS[0].endsWith(':iam::cloudfront:user/CloudFront Origin Access Identity OAITest'));
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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