# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['calcipy', 'calcipy.dev', 'calcipy.doit_tasks']

package_data = \
{'': ['*'], 'calcipy.doit_tasks': ['templates/*']}

install_requires = \
['attrs',
 'beartype',
 'decorator',
 'doit',
 'loguru',
 'pendulum',
 'pre-commit',
 'pyrate_limiter',
 'python-box',
 'pyyaml',
 'requests',
 'sty>=1.0.0rc1,<2.0.0',
 'toml',
 'transitions']

extras_require = \
{'commitizen_legacy': ['cz_legacy'],
 'dev': ['better-exceptions',
         'commitizen',
         'markdown-include',
         'mkdocs-material',
         'pdocs',
         'pyupgrade'],
 'dev:sys_platform != "win32" or python_version < "3.9"': ['pdbpp'],
 'lint': ['add-trailing-comma',
          'autopep8',
          'cohesion',
          'darglint',
          'demjson',
          'dlint',
          'flake8',
          'flake8-2020',
          'flake8-aaa',
          'flake8-annotations',
          'flake8-assertive',
          'flake8-bandit',
          'flake8-blind-except',
          'flake8-breakpoint',
          'flake8-broken-line',
          'flake8-bugbear',
          'flake8-builtins',
          'flake8-cognitive-complexity',
          'flake8-commas',
          'flake8-comprehensions',
          'flake8-debugger',
          'flake8-docstrings',
          'flake8-eradicate',
          'flake8-expression-complexity',
          'flake8-fixme',
          'flake8-functions<0.0.4',
          'flake8-isort',
          'flake8-logging-format',
          'flake8-markdown',
          'flake8-mock',
          'flake8-pep3101',
          'flake8-plone-hasattr',
          'flake8-print',
          'flake8-printf-formatting',
          'flake8-pytest-style',
          'flake8-quotes',
          'flake8-return',
          'flake8-SQL',
          'flake8-string-format',
          'flake8-tuple',
          'flake8-variables-names',
          'hacking>=4,<5',
          'isort>=5,<6',
          'licensecheck',
          'pandas-vet',
          'pep8-naming',
          'proselint',
          'radon',
          'vulture',
          'yamllint'],
 'serializers': ['preconvert', 'preconvert_numpy'],
 'test': ['diff-cover',
          'lxml',
          'mypy',
          'nox-poetry',
          'pytest',
          'pytest-cov',
          'pytest-html',
          'pytest-randomly',
          'pytest-recording',
          'pytest-watch']}

setup_kwargs = {
    'name': 'calcipy',
    'version': '0.2.0',
    'description': 'Python package to simplify development. Includes functionality for task running, testing, linting, documenting, and more',
    'long_description': '# calcipy\n\n![./calcipy.svg](./calcipy.svg)\n\n`calcipy` is a Python package that implements best practices such as code style (linting, auto-fixes), documentation, CI/CD, and logging. Like the calcium carbonate in hard coral, packages can be built on the `calcipy` foundation.\n\n`calcipy` has some configurability, but is still very opinionated for my particular use cases. There are a number of alternatives to consider:\n\n- [tidypy](https://github.com/jayclassless/tidypy#features) offers similar functionality of bundling and running static checkers, but makes far fewer assumptions about the project itself (and has a really nice progress indicator!)\n- [black](https://black.readthedocs.io/en/stable/) is an opinionated, but really popular formatter\n- And many more such as [prospector](https://github.com/PyCQA/prospector), [wemake-python-styleguide](https://github.com/wemake-services/wemake-python-styleguide) / [cjolowicz/cookiecutter-hypermodern-python](https://github.com/cjolowicz/cookiecutter-hypermodern-python), etc.\n\n## Installation\n\nCreate a new project with [kyleking/calcipy_template](https://github.com/KyleKing/calcipy_template/)\n\n```sh\n# See above link for latest documentation, but this snippet should work\npipx install copier\ncopier copy gh:KyleKing/calcipy_template new_project\ncd new_project\n# Static files can then be kept in sync with "copier update"!\n```\n\n!!! tip\n    Note: If needed, the latest version of calcipy can be installed from git by modifying the `pyproject.toml`:\n\n    ```toml\n    [tool.poetry.dependencies.calcipy]\n    git = "https://github.com/kyleking/calcipy.git"\n    branch = "dev/development"\n    rev = "56802cf"  # Always pin to a commit\n    develop = true  # Optional: will reinstall each time\n\n    [tool.poetry.dev-dependencies.calcipy]\n    git = "https://github.com/kyleking/calcipy.git"\n    branch = "dev/development"\n    extras = [ "dev", "lint", "test",]\n    ```\n\n## Usage\n\n1. Run `poetry install`\n2. Check that `poetry run doit` works\n3. Run `poetry run doit list` to see available tasks\n\nIf you have any questions, please [start a Discussion on Github](https://github.com/KyleKing/calcipy/discussions/)\n\nFor more examples, see other projects that use `calcipy`:\n\n- [KyleKing/cz_legacy](https://github.com/KyleKing/cz_legacy) - *Published*\n- [KyleKing/dash_charts](https://github.com/KyleKing/dash_charts) - *WIP*\n- [KyleKing/PiAlarm](https://github.com/KyleKing/PiAlarm) - *On Hold*\n- [KyleKing/Goodreads_Library_Availability](https://github.com/KyleKing/Goodreads_Library_Availability) - *On Hold*\n- See other [projects tagged with the topic "calcipy"](https://github.com/topics/calcipy)\n- Also see: [Scripts](https://github.com/kyleking/calcipy/scripts) or [Tests](https://github.com/kyleking/calcipy/tests)\n\n## Upgrades\n\nReview the [./docs/CHANGELOG.md](./docs/CHANGELOG.md) before updating. Calcipy uses semantic versioning so once `^1.0.0`, breaking changes will only occur during major releases; however, while an alpha-release (`0.#.#`), the project may have breaking changes on minor increments until stable.\n\n```sh\n# Update dependencies\npoetry update\n\n# Update files\ncopier update\n```\n\n## Roadmap\n\nSee the `Open Issues` and `Milestones` for current status and [./docs/CODE_TAG_SUMMARY.md](./docs/CODE_TAG_SUMMARY.md) for annotations in the source code.\n\nFor release history, see the [./docs/CHANGELOG.md](./docs/CHANGELOG.md)\n\n## Contributing\n\nSee the Developer Guide, Contribution Guidelines, etc\n\n- [./docs/DEVELOPER_GUIDE.md](./docs/DEVELOPER_GUIDE.md)\n- [./docs/STYLE_GUIDE.md](./docs/STYLE_GUIDE.md)\n- [./docs/CONTRIBUTING.md](./docs/CONTRIBUTING.md)\n- [./docs/CODE_OF_CONDUCT.md](./docs/CODE_OF_CONDUCT.md)\n- [./docs/SECURITY.md](./docs/SECURITY.md)\n\n## License\n\n[LICENSE](https://github.com/kyleking/calcipy/LICENSE)\n',
    'author': 'Kyle King',
    'author_email': 'dev.act.kyle@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/kyleking/calcipy',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
