"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceGroup = exports.InstanceGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cloudphone_generated_1 = require("./cloudphone.generated");
Object.defineProperty(exports, "InstanceGroupProperty", { enumerable: true, get: function () { return cloudphone_generated_1.RosInstanceGroup; } });
/**
 * A ROS resource type:  `ALIYUN::CloudPhone::InstanceGroup`
 */
class InstanceGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::CloudPhone::InstanceGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstanceGroup = new cloudphone_generated_1.RosInstanceGroup(this, id, {
            keyPairName: props.keyPairName,
            description: props.description,
            amount: props.amount,
            securityGroupId: props.securityGroupId,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            autoPay: props.autoPay,
            instanceName: props.instanceName,
            eipBandwidth: props.eipBandwidth,
            chargeType: props.chargeType,
            imageId: props.imageId,
            vncPassword: props.vncPassword,
            tag: props.tag,
            instanceType: props.instanceType,
            resolution: props.resolution,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstanceGroup;
        this.attrInstanceIds = rosInstanceGroup.attrInstanceIds;
        this.attrOrderId = rosInstanceGroup.attrOrderId;
        this.attrTradePrice = rosInstanceGroup.attrTradePrice;
    }
}
exports.InstanceGroup = InstanceGroup;
//# sourceMappingURL=data:application/json;base64,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