## ERDB: tool for parsing ELDEN RING files

### What this is

ERDB is a CLI tool for parsing an ELDEN RING installation and converting it into a more display-friendly structure in JSON format.
For example, it can collect data from multiple game params about an item and compile it to a single JSON object holding all the properties you could find on a Wikipedia page about it.
This is only the main functionality and it covers all in-game items and more, with a possibility to extend the features thanks to the mini-framework for interacting with ELDEN RING files.

### Who this is for

ERDB is primarily targeted at people developing tools and mods for ELDEN RING.
You can generate data from your installation (native or modded), or use the public REST API (outlined in [Usage](#usage) section) for any existing version of the game.
If you ever created a build planner or any sort of a tool which needs to deal with in-game items, you know how painful it is to get a hold of and store the data and assets.
This is an attempt at unifying that data into something that is easily accessible and parsed by anyone, with instant updates when a new game version releases.

## Usage

There are several ways to use ERDB, and you're probably looking for the last one:

1. **Python package**: `pip install erdb` makes it accessible from CLI by calling `erdb` ([CLI manual](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual)).
1. **Docker image**: Python package in form of a Docker image accepting same arguments ([package page](https://github.com/EldenRingDatabase/erdb/pkgs/container/erdb)).
1. **Docker API image**: built on the regular image, only serves the REST API on port `8107` ([package page](https://github.com/EldenRingDatabase/erdb/pkgs/container/erdb-api)).
1. **Public REST service**: REST API is available without a need to use ERDB directly ([docs](https://api.erdb.wiki/v1/docs), [alt docs](https://api.erdb.wiki/v1/redoc)).

## Tool features

This is a short summary of all subcommands ERDB provides as a CLI tool:

* [`generate`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-generate): Generate JSON data for specified tables.
* [`find-values`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-find-values): Find all possible values of a field per param name.
* [`calculate-ar`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-calculate-ar): Calculate attack power of an armament.
* [`changelog`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-changelog): Create a changelog of ERDB-detectable differences between specified versions.
* [`source`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-source): Extract gamedata from an UXM-unpacked ELDEN RING installation (Windows only).
* [`map`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-map): Extract world map image from an UXM-unpacked ELDEN RING installation (Windows only).
* [`icons`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-icons): Extract item images from an UXM-unpacked ELDEN RING installation (Windows only).
* [`serve-api`](https://github.com/EldenRingDatabase/erdb/wiki/CLI-Interface-Manual#erdb-serve-api): Begin serving the API web server.

## Data features

Adopting the database in a project is beneficial beyond just providing the data itself:

### Reliable sources

* All the data is ripped straight from the game files using [Yabber](https://github.com/JKAnderson/Yabber) and [ERExporter](https://github.com/EldenRingDatabase/ERExporter).
* Mild dependency on Yapped Rune Bear's [Paramdex](https://github.com/vawser/Yapped-Rune-Bear/tree/main/Paramdex/ER) for naming of a few properties.

### 99%<sup>1</sup> of data is autogenerated

* Values are free from human error and always up-to-date.
* Values are effortlessly regenerated with new game releases.
* Convoluted game parameters are converted into a coherent layout, harmless<sup>2</sup> information loss.

### User contributed information

* Made in mind with user contributions, new findings can be available in every adaptation of the database.
* Interesting remarks about an item or a weapon's true combo list is kept up to date.
* Designed for easy PRs where every item is contained within its own file.
* Ability to specify game version ranges for which a particular information is valid.
* Each human change is checked for correctness (by accepting a PR) and validity (by CI) [COMING SOON].

### Thought-through structure

* Structure of JSON designed as shallow and straightforward to parse as possible.
* Digging into nested fields is avoided, while retaining a logically sensible layout.
* Layout adheres to a strictly defined schema with the help of [Pydantic](https://docs.pydantic.dev/), ensuring integrity of all values.
* [FastAPI](https://fastapi.tiangolo.com/) sets up REST endpoints with OpenAPI-compatible documentation.

### Availablility

* Public webserver providing a REST API for remote data retrieval (see [Usage](#usage) section).
* Generate the data yourself and embed it in your app.
* Every released game version is supported, from 1.02.1 and up ([sources](https://github.com/EldenRingDatabase/erdb/tree/master/src/erdb/data/gamedata)).

<sup>1</sup> Some values or means of retrieving them are hardcoded in very specific cases, all listed [here](https://github.com/EldenRingDatabase/erdb/wiki/Data-Generation-Completeness). \
<sup>2</sup> Only unnecessary information is lost, ex. armor pieces have separate values for bleed/frostbite, but are treated as a single "robustness" value in ERDB (as are in-game).
