"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const vpn_1 = require("./vpn");
vpn_1.VpnConnection.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/VPN',
        metricName,
        dimensionsMap: { VpnId: this.vpnId },
        ...props
    }).attachTo(this);
};
vpn_1.VpnConnection.prototype.metricTunnelState = function (props) {
    return this.metric('TunnelState', { statistic: 'Average', ...props });
};
vpn_1.VpnConnection.prototype.metricTunnelDataIn = function (props) {
    return this.metric('TunnelDataIn', { statistic: 'Sum', ...props });
};
vpn_1.VpnConnection.prototype.metricTunnelDataOut = function (props) {
    return this.metric('TunnelDataOut', { statistic: 'Sum', ...props });
};
//# sourceMappingURL=data:application/json;base64,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