"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplateRequireImdsv2Aspect = exports.InstanceRequireImdsv2Aspect = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const cxapi = require("@aws-cdk/cx-api");
const ec2_generated_1 = require("../ec2.generated");
const instance_1 = require("../instance");
const launch_template_1 = require("../launch-template");
/**
 * Base class for Aspect that makes IMDSv2 required.
 */
class RequireImdsv2Aspect {
    constructor(props) {
        var _c;
        this.suppressWarnings = (_c = props === null || props === void 0 ? void 0 : props.suppressWarnings) !== null && _c !== void 0 ? _c : false;
    }
    /**
     * Adds a warning annotation to a node, unless `suppressWarnings` is true.
     *
     * @param node The scope to add the warning to.
     * @param message The warning message.
     */
    warn(node, message) {
        if (this.suppressWarnings !== true) {
            cdk.Annotations.of(node).addWarning(`${RequireImdsv2Aspect.name} failed on node ${node.node.id}: ${message}`);
        }
    }
}
/**
 * Aspect that applies IMDS configuration on EC2 Instance constructs.
 *
 * This aspect configures IMDS on an EC2 instance by creating a Launch Template with the
 * IMDS configuration and associating that Launch Template with the instance. If an Instance
 * is already associated with a Launch Template, a warning will (optionally) be added to the
 * construct node and it will be skipped.
 *
 * To cover Instances already associated with Launch Templates, use `LaunchTemplateImdsAspect`.
 */
class InstanceRequireImdsv2Aspect extends RequireImdsv2Aspect {
    constructor(props) {
        var _c;
        super(props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceRequireImdsv2AspectProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.suppressLaunchTemplateWarning = (_c = props === null || props === void 0 ? void 0 : props.suppressLaunchTemplateWarning) !== null && _c !== void 0 ? _c : false;
    }
    visit(node) {
        if (!(node instanceof instance_1.Instance)) {
            return;
        }
        if (node.instance.launchTemplate !== undefined) {
            this.warn(node, 'Cannot toggle IMDSv1 because this Instance is associated with an existing Launch Template.');
            return;
        }
        const launchTemplate = new ec2_generated_1.CfnLaunchTemplate(node, 'LaunchTemplate', {
            launchTemplateData: {
                metadataOptions: {
                    httpTokens: 'required',
                },
            },
        });
        if (core_1.FeatureFlags.of(node).isEnabled(cxapi.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME)) {
            launchTemplate.launchTemplateName = cdk.Names.uniqueId(launchTemplate);
        }
        else {
            launchTemplate.launchTemplateName = `${node.node.id}LaunchTemplate`;
        }
        node.instance.launchTemplate = {
            launchTemplateName: launchTemplate.launchTemplateName,
            version: launchTemplate.getAtt('LatestVersionNumber').toString(),
        };
    }
    warn(node, message) {
        if (this.suppressLaunchTemplateWarning !== true) {
            super.warn(node, message);
        }
    }
}
exports.InstanceRequireImdsv2Aspect = InstanceRequireImdsv2Aspect;
_a = JSII_RTTI_SYMBOL_1;
InstanceRequireImdsv2Aspect[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceRequireImdsv2Aspect", version: "1.156.1" };
/**
 * Aspect that applies IMDS configuration on EC2 Launch Template constructs.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html
 */
class LaunchTemplateRequireImdsv2Aspect extends RequireImdsv2Aspect {
    constructor(props) {
        super(props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_LaunchTemplateRequireImdsv2AspectProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    visit(node) {
        if (!(node instanceof launch_template_1.LaunchTemplate)) {
            return;
        }
        const launchTemplate = node.node.tryFindChild('Resource');
        const data = launchTemplate.launchTemplateData;
        if (cdk.isResolvableObject(data)) {
            this.warn(node, 'LaunchTemplateData is a CDK token.');
            return;
        }
        const metadataOptions = data.metadataOptions;
        if (cdk.isResolvableObject(metadataOptions)) {
            this.warn(node, 'LaunchTemplateData.MetadataOptions is a CDK token.');
            return;
        }
        const newData = {
            ...data,
            metadataOptions: {
                ...metadataOptions,
                httpTokens: 'required',
            },
        };
        launchTemplate.launchTemplateData = newData;
    }
}
exports.LaunchTemplateRequireImdsv2Aspect = LaunchTemplateRequireImdsv2Aspect;
_b = JSII_RTTI_SYMBOL_1;
LaunchTemplateRequireImdsv2Aspect[_b] = { fqn: "@aws-cdk/aws-ec2.LaunchTemplateRequireImdsv2Aspect", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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