# Aptos Python SDK

[![Discord][discord-image]][discord-url]
[![PyPI Package Version][pypi-image-version]][pypi-url]
[![PyPI Package Downloads][pypi-image-downloads]][pypi-url]

You need to connect to an [Aptos](https:/github.com/aptos-labs/aptos-core/) node to use this library, or run one
yourself locally.

## Usage

Currently this is still in development and is unsuitable for directly interfacing with Aptos.

### Requirements

- [Black](https://github.com/psf/black)
- [PyNaCl](https://pypi.org/project/PyNaCl/)

### Testing

To run all unit tests:
```bash
python3 -m unittest discover -s aptos_sdk/ -p '*.py' -t ..
```

To run all end-to-end tests:
```bash
ln -s `pwd`/aptos_sdk examples/
python3 -m examples.coin
python3 -m examples.token
```

Note: end-to-end tests rely on [Aptos Devnet](https://aptos.dev/guides/getting-started#aptos-devnet).

### Autoformatting

```bash
find aptos_sdk -type f -name "*.py" | xargs python3 -m black
find aptos_sdk -type f -name "*.py" | xargs python3 -m autoflake -i -r --remove-all-unused-imports --remove-unused-variables --ignore-init-module-imports
find aptos_sdk -type f -name "*.py" | xargs python3 -m isort
```

### Generating types

The Python `openapi-python-client` tool cannot parse references. Therefore there are three options:
* Use swagger-cli to dereference, gain a type explosion, and still have missing types
* Live without missing types
* Write a pure python implementation with no autogenerated code

Currently the team is moving forward with pure python, but leaves the following notes for the curious:

```bash
npm install  -g @apidevtools/swagger-cli
swagger-cli bundle --dereference ../../../api/doc/v0/openapi.yaml  -t yaml > openapi.yaml
python3 -m openapi_python_client generate --path openapi.yaml
mv aptos-dev-api-specification-client/aptos_dev_api_specification_client/ aptos_sdk/openapi
```

## Semantic versioning

This project follows [semver](https://semver.org/) as closely as possible

[repo]: https://github.com/aptos-labs/aptos-core

[pypi-image-version]: https://img.shields.io/pypi/v/aptos-sdk.svg

[pypi-image-downloads]: https://img.shields.io/pypi/dm/aptos-sdk.svg

[pypi-url]: https://pypi.org/project/aptos-sdk

[discord-image]: https://img.shields.io/discord/945856774056083548?label=Discord&logo=discord&style=flat~~~~

[discord-url]:  https://discord.gg/aptoslabs
