import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WindowsVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#admin_password WindowsVirtualMachineScaleSet#admin_password}
    */
    readonly adminPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#admin_username WindowsVirtualMachineScaleSet#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#computer_name_prefix WindowsVirtualMachineScaleSet#computer_name_prefix}
    */
    readonly computerNamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#custom_data WindowsVirtualMachineScaleSet#custom_data}
    */
    readonly customData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#do_not_run_extensions_on_overprovisioned_machines WindowsVirtualMachineScaleSet#do_not_run_extensions_on_overprovisioned_machines}
    */
    readonly doNotRunExtensionsOnOverprovisionedMachines?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#enable_automatic_updates WindowsVirtualMachineScaleSet#enable_automatic_updates}
    */
    readonly enableAutomaticUpdates?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#encryption_at_host_enabled WindowsVirtualMachineScaleSet#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#health_probe_id WindowsVirtualMachineScaleSet#health_probe_id}
    */
    readonly healthProbeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#id WindowsVirtualMachineScaleSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#instances WindowsVirtualMachineScaleSet#instances}
    */
    readonly instances: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#license_type WindowsVirtualMachineScaleSet#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#location WindowsVirtualMachineScaleSet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#name WindowsVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#overprovision WindowsVirtualMachineScaleSet#overprovision}
    */
    readonly overprovision?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#platform_fault_domain_count WindowsVirtualMachineScaleSet#platform_fault_domain_count}
    */
    readonly platformFaultDomainCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#provision_vm_agent WindowsVirtualMachineScaleSet#provision_vm_agent}
    */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#resource_group_name WindowsVirtualMachineScaleSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#scale_in_policy WindowsVirtualMachineScaleSet#scale_in_policy}
    */
    readonly scaleInPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#single_placement_group WindowsVirtualMachineScaleSet#single_placement_group}
    */
    readonly singlePlacementGroup?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#sku WindowsVirtualMachineScaleSet#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#source_image_id WindowsVirtualMachineScaleSet#source_image_id}
    */
    readonly sourceImageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#tags WindowsVirtualMachineScaleSet#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#timezone WindowsVirtualMachineScaleSet#timezone}
    */
    readonly timezone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#upgrade_mode WindowsVirtualMachineScaleSet#upgrade_mode}
    */
    readonly upgradeMode?: string;
    /**
    * additional_capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#additional_capabilities WindowsVirtualMachineScaleSet#additional_capabilities}
    */
    readonly additionalCapabilities?: WindowsVirtualMachineScaleSetAdditionalCapabilities;
    /**
    * additional_unattend_content block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#additional_unattend_content WindowsVirtualMachineScaleSet#additional_unattend_content}
    */
    readonly additionalUnattendContent?: WindowsVirtualMachineScaleSetAdditionalUnattendContent[] | cdktf.IResolvable;
    /**
    * automatic_instance_repair block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#automatic_instance_repair WindowsVirtualMachineScaleSet#automatic_instance_repair}
    */
    readonly automaticInstanceRepair?: WindowsVirtualMachineScaleSetAutomaticInstanceRepair;
    /**
    * automatic_os_upgrade_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#automatic_os_upgrade_policy WindowsVirtualMachineScaleSet#automatic_os_upgrade_policy}
    */
    readonly automaticOsUpgradePolicy?: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy;
    /**
    * boot_diagnostics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#boot_diagnostics WindowsVirtualMachineScaleSet#boot_diagnostics}
    */
    readonly bootDiagnostics?: WindowsVirtualMachineScaleSetBootDiagnostics;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#data_disk WindowsVirtualMachineScaleSet#data_disk}
    */
    readonly dataDisk?: WindowsVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#extension WindowsVirtualMachineScaleSet#extension}
    */
    readonly extension?: WindowsVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#network_interface WindowsVirtualMachineScaleSet#network_interface}
    */
    readonly networkInterface: WindowsVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#os_disk WindowsVirtualMachineScaleSet#os_disk}
    */
    readonly osDisk: WindowsVirtualMachineScaleSetOsDisk;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#plan WindowsVirtualMachineScaleSet#plan}
    */
    readonly plan?: WindowsVirtualMachineScaleSetPlan;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#secret WindowsVirtualMachineScaleSet#secret}
    */
    readonly secret?: WindowsVirtualMachineScaleSetSecret[] | cdktf.IResolvable;
    /**
    * source_image_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#source_image_reference WindowsVirtualMachineScaleSet#source_image_reference}
    */
    readonly sourceImageReference?: WindowsVirtualMachineScaleSetSourceImageReference;
    /**
    * terminate_notification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#terminate_notification WindowsVirtualMachineScaleSet#terminate_notification}
    */
    readonly terminateNotification?: WindowsVirtualMachineScaleSetTerminateNotification;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#timeouts WindowsVirtualMachineScaleSet#timeouts}
    */
    readonly timeouts?: WindowsVirtualMachineScaleSetTimeouts;
    /**
    * winrm_listener block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#winrm_listener WindowsVirtualMachineScaleSet#winrm_listener}
    */
    readonly winrmListener?: WindowsVirtualMachineScaleSetWinrmListener[] | cdktf.IResolvable;
}
export interface WindowsVirtualMachineScaleSetAdditionalCapabilities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#ultra_ssd_enabled WindowsVirtualMachineScaleSet#ultra_ssd_enabled}
    */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetAdditionalCapabilitiesToTerraform(struct?: WindowsVirtualMachineScaleSetAdditionalCapabilitiesOutputReference | WindowsVirtualMachineScaleSetAdditionalCapabilities): any;
export declare class WindowsVirtualMachineScaleSetAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetAdditionalCapabilities | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    resetUltraSsdEnabled(): void;
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsVirtualMachineScaleSetAdditionalUnattendContent {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#content WindowsVirtualMachineScaleSet#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#setting WindowsVirtualMachineScaleSet#setting}
    */
    readonly setting: string;
}
export declare function windowsVirtualMachineScaleSetAdditionalUnattendContentToTerraform(struct?: WindowsVirtualMachineScaleSetAdditionalUnattendContent | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetAdditionalUnattendContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetAdditionalUnattendContent | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetAdditionalUnattendContent | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _setting?;
    get setting(): string;
    set setting(value: string);
    get settingInput(): string | undefined;
}
export declare class WindowsVirtualMachineScaleSetAdditionalUnattendContentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetAdditionalUnattendContent[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetAdditionalUnattendContentOutputReference;
}
export interface WindowsVirtualMachineScaleSetAutomaticInstanceRepair {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#enabled WindowsVirtualMachineScaleSet#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#grace_period WindowsVirtualMachineScaleSet#grace_period}
    */
    readonly gracePeriod?: string;
}
export declare function windowsVirtualMachineScaleSetAutomaticInstanceRepairToTerraform(struct?: WindowsVirtualMachineScaleSetAutomaticInstanceRepairOutputReference | WindowsVirtualMachineScaleSetAutomaticInstanceRepair): any;
export declare class WindowsVirtualMachineScaleSetAutomaticInstanceRepairOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetAutomaticInstanceRepair | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): string;
    set gracePeriod(value: string);
    resetGracePeriod(): void;
    get gracePeriodInput(): string | undefined;
}
export interface WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#disable_automatic_rollback WindowsVirtualMachineScaleSet#disable_automatic_rollback}
    */
    readonly disableAutomaticRollback: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#enable_automatic_os_upgrade WindowsVirtualMachineScaleSet#enable_automatic_os_upgrade}
    */
    readonly enableAutomaticOsUpgrade: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetAutomaticOsUpgradePolicyToTerraform(struct?: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference | WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy): any;
export declare class WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined);
    private _disableAutomaticRollback?;
    get disableAutomaticRollback(): boolean | cdktf.IResolvable;
    set disableAutomaticRollback(value: boolean | cdktf.IResolvable);
    get disableAutomaticRollbackInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutomaticOsUpgrade?;
    get enableAutomaticOsUpgrade(): boolean | cdktf.IResolvable;
    set enableAutomaticOsUpgrade(value: boolean | cdktf.IResolvable);
    get enableAutomaticOsUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsVirtualMachineScaleSetBootDiagnostics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#storage_account_uri WindowsVirtualMachineScaleSet#storage_account_uri}
    */
    readonly storageAccountUri: string;
}
export declare function windowsVirtualMachineScaleSetBootDiagnosticsToTerraform(struct?: WindowsVirtualMachineScaleSetBootDiagnosticsOutputReference | WindowsVirtualMachineScaleSetBootDiagnostics): any;
export declare class WindowsVirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetBootDiagnostics | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetBootDiagnostics | undefined);
    private _storageAccountUri?;
    get storageAccountUri(): string;
    set storageAccountUri(value: string);
    get storageAccountUriInput(): string | undefined;
}
export interface WindowsVirtualMachineScaleSetDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#caching WindowsVirtualMachineScaleSet#caching}
    */
    readonly caching: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#create_option WindowsVirtualMachineScaleSet#create_option}
    */
    readonly createOption?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#disk_encryption_set_id WindowsVirtualMachineScaleSet#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#disk_size_gb WindowsVirtualMachineScaleSet#disk_size_gb}
    */
    readonly diskSizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#lun WindowsVirtualMachineScaleSet#lun}
    */
    readonly lun: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#storage_account_type WindowsVirtualMachineScaleSet#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#write_accelerator_enabled WindowsVirtualMachineScaleSet#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetDataDiskToTerraform(struct?: WindowsVirtualMachineScaleSetDataDisk | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetDataDisk | cdktf.IResolvable | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    get cachingInput(): string | undefined;
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    resetCreateOption(): void;
    get createOptionInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    get diskSizeGbInput(): number | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class WindowsVirtualMachineScaleSetDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetDataDiskOutputReference;
}
export interface WindowsVirtualMachineScaleSetExtension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#auto_upgrade_minor_version WindowsVirtualMachineScaleSet#auto_upgrade_minor_version}
    */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#automatic_upgrade_enabled WindowsVirtualMachineScaleSet#automatic_upgrade_enabled}
    */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#force_update_tag WindowsVirtualMachineScaleSet#force_update_tag}
    */
    readonly forceUpdateTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#name WindowsVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#protected_settings WindowsVirtualMachineScaleSet#protected_settings}
    */
    readonly protectedSettings?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#provision_after_extensions WindowsVirtualMachineScaleSet#provision_after_extensions}
    */
    readonly provisionAfterExtensions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#publisher WindowsVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#settings WindowsVirtualMachineScaleSet#settings}
    */
    readonly settings?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#type WindowsVirtualMachineScaleSet#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#type_handler_version WindowsVirtualMachineScaleSet#type_handler_version}
    */
    readonly typeHandlerVersion: string;
}
export declare function windowsVirtualMachineScaleSetExtensionToTerraform(struct?: WindowsVirtualMachineScaleSetExtension | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetExtension | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetExtension | cdktf.IResolvable | undefined);
    private _autoUpgradeMinorVersion?;
    get autoUpgradeMinorVersion(): boolean | cdktf.IResolvable;
    set autoUpgradeMinorVersion(value: boolean | cdktf.IResolvable);
    resetAutoUpgradeMinorVersion(): void;
    get autoUpgradeMinorVersionInput(): boolean | cdktf.IResolvable | undefined;
    private _automaticUpgradeEnabled?;
    get automaticUpgradeEnabled(): boolean | cdktf.IResolvable;
    set automaticUpgradeEnabled(value: boolean | cdktf.IResolvable);
    resetAutomaticUpgradeEnabled(): void;
    get automaticUpgradeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _forceUpdateTag?;
    get forceUpdateTag(): string;
    set forceUpdateTag(value: string);
    resetForceUpdateTag(): void;
    get forceUpdateTagInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protectedSettings?;
    get protectedSettings(): string;
    set protectedSettings(value: string);
    resetProtectedSettings(): void;
    get protectedSettingsInput(): string | undefined;
    private _provisionAfterExtensions?;
    get provisionAfterExtensions(): string[];
    set provisionAfterExtensions(value: string[]);
    resetProvisionAfterExtensions(): void;
    get provisionAfterExtensionsInput(): string[] | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _settings?;
    get settings(): string;
    set settings(value: string);
    resetSettings(): void;
    get settingsInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeHandlerVersion?;
    get typeHandlerVersion(): string;
    set typeHandlerVersion(value: string);
    get typeHandlerVersionInput(): string | undefined;
}
export declare class WindowsVirtualMachineScaleSetExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetExtensionOutputReference;
}
export interface WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#load_balancer_backend_address_pool_ids WindowsVirtualMachineScaleSet#load_balancer_backend_address_pool_ids}
    */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#load_balancer_inbound_nat_rules_ids WindowsVirtualMachineScaleSet#load_balancer_inbound_nat_rules_ids}
    */
    readonly loadBalancerInboundNatRulesIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#name WindowsVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#primary WindowsVirtualMachineScaleSet#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#subnet_id WindowsVirtualMachineScaleSet#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#version WindowsVirtualMachineScaleSet#version}
    */
    readonly version?: string;
}
export declare function windowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationToTerraform(struct?: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined);
    private _loadBalancerBackendAddressPoolIds?;
    get loadBalancerBackendAddressPoolIds(): string[];
    set loadBalancerBackendAddressPoolIds(value: string[]);
    resetLoadBalancerBackendAddressPoolIds(): void;
    get loadBalancerBackendAddressPoolIdsInput(): string[] | undefined;
    private _loadBalancerInboundNatRulesIds?;
    get loadBalancerInboundNatRulesIds(): string[];
    set loadBalancerInboundNatRulesIds(value: string[]);
    resetLoadBalancerInboundNatRulesIds(): void;
    get loadBalancerInboundNatRulesIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export declare class WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference;
}
export interface WindowsVirtualMachineScaleSetNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#dns_servers WindowsVirtualMachineScaleSet#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#enable_ip_forwarding WindowsVirtualMachineScaleSet#enable_ip_forwarding}
    */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#name WindowsVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#network_security_group_id WindowsVirtualMachineScaleSet#network_security_group_id}
    */
    readonly networkSecurityGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#primary WindowsVirtualMachineScaleSet#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#ip_configuration WindowsVirtualMachineScaleSet#ip_configuration}
    */
    readonly ipConfiguration: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetNetworkInterfaceToTerraform(struct?: WindowsVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable | undefined);
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _enableIpForwarding?;
    get enableIpForwarding(): boolean | cdktf.IResolvable;
    set enableIpForwarding(value: boolean | cdktf.IResolvable);
    resetEnableIpForwarding(): void;
    get enableIpForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkSecurityGroupId?;
    get networkSecurityGroupId(): string;
    set networkSecurityGroupId(value: string);
    resetNetworkSecurityGroupId(): void;
    get networkSecurityGroupIdInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _ipConfiguration;
    get ipConfiguration(): WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationList;
    putIpConfiguration(value: WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable): void;
    get ipConfigurationInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | undefined;
}
export declare class WindowsVirtualMachineScaleSetNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetNetworkInterfaceOutputReference;
}
export interface WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#option WindowsVirtualMachineScaleSet#option}
    */
    readonly option: string;
}
export declare function windowsVirtualMachineScaleSetOsDiskDiffDiskSettingsToTerraform(struct?: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference | WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings): any;
export declare class WindowsVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined);
    private _option?;
    get option(): string;
    set option(value: string);
    get optionInput(): string | undefined;
}
export interface WindowsVirtualMachineScaleSetOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#caching WindowsVirtualMachineScaleSet#caching}
    */
    readonly caching: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#disk_encryption_set_id WindowsVirtualMachineScaleSet#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#disk_size_gb WindowsVirtualMachineScaleSet#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#storage_account_type WindowsVirtualMachineScaleSet#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#write_accelerator_enabled WindowsVirtualMachineScaleSet#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
    * diff_disk_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#diff_disk_settings WindowsVirtualMachineScaleSet#diff_disk_settings}
    */
    readonly diffDiskSettings?: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings;
}
export declare function windowsVirtualMachineScaleSetOsDiskToTerraform(struct?: WindowsVirtualMachineScaleSetOsDiskOutputReference | WindowsVirtualMachineScaleSetOsDisk): any;
export declare class WindowsVirtualMachineScaleSetOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetOsDisk | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetOsDisk | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    get diffDiskSettings(): WindowsVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference;
    putDiffDiskSettings(value: WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings): void;
    resetDiffDiskSettings(): void;
    get diffDiskSettingsInput(): WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
}
export interface WindowsVirtualMachineScaleSetPlan {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#name WindowsVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#product WindowsVirtualMachineScaleSet#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#publisher WindowsVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
}
export declare function windowsVirtualMachineScaleSetPlanToTerraform(struct?: WindowsVirtualMachineScaleSetPlanOutputReference | WindowsVirtualMachineScaleSetPlan): any;
export declare class WindowsVirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetPlan | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetPlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface WindowsVirtualMachineScaleSetSecretCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#store WindowsVirtualMachineScaleSet#store}
    */
    readonly store: string;
}
export declare function windowsVirtualMachineScaleSetSecretCertificateToTerraform(struct?: WindowsVirtualMachineScaleSetSecretCertificate | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetSecretCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetSecretCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetSecretCertificate | cdktf.IResolvable | undefined);
    private _store?;
    get store(): string;
    set store(value: string);
    get storeInput(): string | undefined;
}
export declare class WindowsVirtualMachineScaleSetSecretCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetSecretCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetSecretCertificateOutputReference;
}
export interface WindowsVirtualMachineScaleSetSecret {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#key_vault_id WindowsVirtualMachineScaleSet#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#certificate WindowsVirtualMachineScaleSet#certificate}
    */
    readonly certificate: WindowsVirtualMachineScaleSetSecretCertificate[] | cdktf.IResolvable;
}
export declare function windowsVirtualMachineScaleSetSecretToTerraform(struct?: WindowsVirtualMachineScaleSetSecret | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetSecret | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetSecret | cdktf.IResolvable | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _certificate;
    get certificate(): WindowsVirtualMachineScaleSetSecretCertificateList;
    putCertificate(value: WindowsVirtualMachineScaleSetSecretCertificate[] | cdktf.IResolvable): void;
    get certificateInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetSecretCertificate[] | undefined;
}
export declare class WindowsVirtualMachineScaleSetSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetSecretOutputReference;
}
export interface WindowsVirtualMachineScaleSetSourceImageReference {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#offer WindowsVirtualMachineScaleSet#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#publisher WindowsVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#sku WindowsVirtualMachineScaleSet#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#version WindowsVirtualMachineScaleSet#version}
    */
    readonly version: string;
}
export declare function windowsVirtualMachineScaleSetSourceImageReferenceToTerraform(struct?: WindowsVirtualMachineScaleSetSourceImageReferenceOutputReference | WindowsVirtualMachineScaleSetSourceImageReference): any;
export declare class WindowsVirtualMachineScaleSetSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetSourceImageReference | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetSourceImageReference | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface WindowsVirtualMachineScaleSetTerminateNotification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#enabled WindowsVirtualMachineScaleSet#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#timeout WindowsVirtualMachineScaleSet#timeout}
    */
    readonly timeout?: string;
}
export declare function windowsVirtualMachineScaleSetTerminateNotificationToTerraform(struct?: WindowsVirtualMachineScaleSetTerminateNotificationOutputReference | WindowsVirtualMachineScaleSetTerminateNotification): any;
export declare class WindowsVirtualMachineScaleSetTerminateNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetTerminateNotification | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetTerminateNotification | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface WindowsVirtualMachineScaleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#create WindowsVirtualMachineScaleSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#delete WindowsVirtualMachineScaleSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#read WindowsVirtualMachineScaleSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#update WindowsVirtualMachineScaleSet#update}
    */
    readonly update?: string;
}
export declare function windowsVirtualMachineScaleSetTimeoutsToTerraform(struct?: WindowsVirtualMachineScaleSetTimeoutsOutputReference | WindowsVirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface WindowsVirtualMachineScaleSetWinrmListener {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set#protocol WindowsVirtualMachineScaleSet#protocol}
    */
    readonly protocol: string;
}
export declare function windowsVirtualMachineScaleSetWinrmListenerToTerraform(struct?: WindowsVirtualMachineScaleSetWinrmListener | cdktf.IResolvable): any;
export declare class WindowsVirtualMachineScaleSetWinrmListenerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsVirtualMachineScaleSetWinrmListener | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsVirtualMachineScaleSetWinrmListener | cdktf.IResolvable | undefined);
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class WindowsVirtualMachineScaleSetWinrmListenerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsVirtualMachineScaleSetWinrmListener[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsVirtualMachineScaleSetWinrmListenerOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set azurestack_windows_virtual_machine_scale_set}
*/
export declare class WindowsVirtualMachineScaleSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurestack_windows_virtual_machine_scale_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/r/windows_virtual_machine_scale_set azurestack_windows_virtual_machine_scale_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WindowsVirtualMachineScaleSetConfig
    */
    constructor(scope: Construct, id: string, config: WindowsVirtualMachineScaleSetConfig);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _computerNamePrefix?;
    get computerNamePrefix(): string;
    set computerNamePrefix(value: string);
    resetComputerNamePrefix(): void;
    get computerNamePrefixInput(): string | undefined;
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _doNotRunExtensionsOnOverprovisionedMachines?;
    get doNotRunExtensionsOnOverprovisionedMachines(): boolean | cdktf.IResolvable;
    set doNotRunExtensionsOnOverprovisionedMachines(value: boolean | cdktf.IResolvable);
    resetDoNotRunExtensionsOnOverprovisionedMachines(): void;
    get doNotRunExtensionsOnOverprovisionedMachinesInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutomaticUpdates?;
    get enableAutomaticUpdates(): boolean | cdktf.IResolvable;
    set enableAutomaticUpdates(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticUpdates(): void;
    get enableAutomaticUpdatesInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _healthProbeId?;
    get healthProbeId(): string;
    set healthProbeId(value: string);
    resetHealthProbeId(): void;
    get healthProbeIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instances?;
    get instances(): number;
    set instances(value: number);
    get instancesInput(): number | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _overprovision?;
    get overprovision(): boolean | cdktf.IResolvable;
    set overprovision(value: boolean | cdktf.IResolvable);
    resetOverprovision(): void;
    get overprovisionInput(): boolean | cdktf.IResolvable | undefined;
    private _platformFaultDomainCount?;
    get platformFaultDomainCount(): number;
    set platformFaultDomainCount(value: number);
    resetPlatformFaultDomainCount(): void;
    get platformFaultDomainCountInput(): number | undefined;
    private _provisionVmAgent?;
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    resetProvisionVmAgent(): void;
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scaleInPolicy?;
    get scaleInPolicy(): string;
    set scaleInPolicy(value: string);
    resetScaleInPolicy(): void;
    get scaleInPolicyInput(): string | undefined;
    private _singlePlacementGroup?;
    get singlePlacementGroup(): boolean | cdktf.IResolvable;
    set singlePlacementGroup(value: boolean | cdktf.IResolvable);
    resetSinglePlacementGroup(): void;
    get singlePlacementGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _sourceImageId?;
    get sourceImageId(): string;
    set sourceImageId(value: string);
    resetSourceImageId(): void;
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    get uniqueId(): string;
    private _upgradeMode?;
    get upgradeMode(): string;
    set upgradeMode(value: string);
    resetUpgradeMode(): void;
    get upgradeModeInput(): string | undefined;
    private _additionalCapabilities;
    get additionalCapabilities(): WindowsVirtualMachineScaleSetAdditionalCapabilitiesOutputReference;
    putAdditionalCapabilities(value: WindowsVirtualMachineScaleSetAdditionalCapabilities): void;
    resetAdditionalCapabilities(): void;
    get additionalCapabilitiesInput(): WindowsVirtualMachineScaleSetAdditionalCapabilities | undefined;
    private _additionalUnattendContent;
    get additionalUnattendContent(): WindowsVirtualMachineScaleSetAdditionalUnattendContentList;
    putAdditionalUnattendContent(value: WindowsVirtualMachineScaleSetAdditionalUnattendContent[] | cdktf.IResolvable): void;
    resetAdditionalUnattendContent(): void;
    get additionalUnattendContentInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetAdditionalUnattendContent[] | undefined;
    private _automaticInstanceRepair;
    get automaticInstanceRepair(): WindowsVirtualMachineScaleSetAutomaticInstanceRepairOutputReference;
    putAutomaticInstanceRepair(value: WindowsVirtualMachineScaleSetAutomaticInstanceRepair): void;
    resetAutomaticInstanceRepair(): void;
    get automaticInstanceRepairInput(): WindowsVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    private _automaticOsUpgradePolicy;
    get automaticOsUpgradePolicy(): WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference;
    putAutomaticOsUpgradePolicy(value: WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy): void;
    resetAutomaticOsUpgradePolicy(): void;
    get automaticOsUpgradePolicyInput(): WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    private _bootDiagnostics;
    get bootDiagnostics(): WindowsVirtualMachineScaleSetBootDiagnosticsOutputReference;
    putBootDiagnostics(value: WindowsVirtualMachineScaleSetBootDiagnostics): void;
    resetBootDiagnostics(): void;
    get bootDiagnosticsInput(): WindowsVirtualMachineScaleSetBootDiagnostics | undefined;
    private _dataDisk;
    get dataDisk(): WindowsVirtualMachineScaleSetDataDiskList;
    putDataDisk(value: WindowsVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable): void;
    resetDataDisk(): void;
    get dataDiskInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetDataDisk[] | undefined;
    private _extension;
    get extension(): WindowsVirtualMachineScaleSetExtensionList;
    putExtension(value: WindowsVirtualMachineScaleSetExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetExtension[] | undefined;
    private _networkInterface;
    get networkInterface(): WindowsVirtualMachineScaleSetNetworkInterfaceList;
    putNetworkInterface(value: WindowsVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable): void;
    get networkInterfaceInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetNetworkInterface[] | undefined;
    private _osDisk;
    get osDisk(): WindowsVirtualMachineScaleSetOsDiskOutputReference;
    putOsDisk(value: WindowsVirtualMachineScaleSetOsDisk): void;
    get osDiskInput(): WindowsVirtualMachineScaleSetOsDisk | undefined;
    private _plan;
    get plan(): WindowsVirtualMachineScaleSetPlanOutputReference;
    putPlan(value: WindowsVirtualMachineScaleSetPlan): void;
    resetPlan(): void;
    get planInput(): WindowsVirtualMachineScaleSetPlan | undefined;
    private _secret;
    get secret(): WindowsVirtualMachineScaleSetSecretList;
    putSecret(value: WindowsVirtualMachineScaleSetSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetSecret[] | undefined;
    private _sourceImageReference;
    get sourceImageReference(): WindowsVirtualMachineScaleSetSourceImageReferenceOutputReference;
    putSourceImageReference(value: WindowsVirtualMachineScaleSetSourceImageReference): void;
    resetSourceImageReference(): void;
    get sourceImageReferenceInput(): WindowsVirtualMachineScaleSetSourceImageReference | undefined;
    private _terminateNotification;
    get terminateNotification(): WindowsVirtualMachineScaleSetTerminateNotificationOutputReference;
    putTerminateNotification(value: WindowsVirtualMachineScaleSetTerminateNotification): void;
    resetTerminateNotification(): void;
    get terminateNotificationInput(): WindowsVirtualMachineScaleSetTerminateNotification | undefined;
    private _timeouts;
    get timeouts(): WindowsVirtualMachineScaleSetTimeoutsOutputReference;
    putTimeouts(value: WindowsVirtualMachineScaleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetTimeouts | undefined;
    private _winrmListener;
    get winrmListener(): WindowsVirtualMachineScaleSetWinrmListenerList;
    putWinrmListener(value: WindowsVirtualMachineScaleSetWinrmListener[] | cdktf.IResolvable): void;
    resetWinrmListener(): void;
    get winrmListenerInput(): cdktf.IResolvable | WindowsVirtualMachineScaleSetWinrmListener[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
