import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackPublicIpsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#allocation_type DataAzurestackPublicIps#allocation_type}
    */
    readonly allocationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#attached DataAzurestackPublicIps#attached}
    */
    readonly attached?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#attachment_status DataAzurestackPublicIps#attachment_status}
    */
    readonly attachmentStatus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#id DataAzurestackPublicIps#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#name_prefix DataAzurestackPublicIps#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#resource_group_name DataAzurestackPublicIps#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#timeouts DataAzurestackPublicIps#timeouts}
    */
    readonly timeouts?: DataAzurestackPublicIpsTimeouts;
}
export interface DataAzurestackPublicIpsPublicIps {
}
export declare function dataAzurestackPublicIpsPublicIpsToTerraform(struct?: DataAzurestackPublicIpsPublicIps): any;
export declare class DataAzurestackPublicIpsPublicIpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackPublicIpsPublicIps | undefined;
    set internalValue(value: DataAzurestackPublicIpsPublicIps | undefined);
    get domainNameLabel(): string;
    get fqdn(): string;
    get id(): string;
    get ipAddress(): string;
    get name(): string;
}
export declare class DataAzurestackPublicIpsPublicIpsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackPublicIpsPublicIpsOutputReference;
}
export interface DataAzurestackPublicIpsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips#read DataAzurestackPublicIps#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackPublicIpsTimeoutsToTerraform(struct?: DataAzurestackPublicIpsTimeoutsOutputReference | DataAzurestackPublicIpsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackPublicIpsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackPublicIpsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackPublicIpsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips azurestack_public_ips}
*/
export declare class DataAzurestackPublicIps extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_public_ips";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/public_ips azurestack_public_ips} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackPublicIpsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackPublicIpsConfig);
    private _allocationType?;
    get allocationType(): string;
    set allocationType(value: string);
    resetAllocationType(): void;
    get allocationTypeInput(): string | undefined;
    private _attached?;
    get attached(): boolean | cdktf.IResolvable;
    set attached(value: boolean | cdktf.IResolvable);
    resetAttached(): void;
    get attachedInput(): boolean | cdktf.IResolvable | undefined;
    private _attachmentStatus?;
    get attachmentStatus(): string;
    set attachmentStatus(value: string);
    resetAttachmentStatus(): void;
    get attachmentStatusInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _publicIps;
    get publicIps(): DataAzurestackPublicIpsPublicIpsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurestackPublicIpsTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackPublicIpsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackPublicIpsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
