import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackLbRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule#id DataAzurestackLbRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule#loadbalancer_id DataAzurestackLbRule#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule#name DataAzurestackLbRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule#resource_group_name DataAzurestackLbRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule#timeouts DataAzurestackLbRule#timeouts}
    */
    readonly timeouts?: DataAzurestackLbRuleTimeouts;
}
export interface DataAzurestackLbRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule#read DataAzurestackLbRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackLbRuleTimeoutsToTerraform(struct?: DataAzurestackLbRuleTimeoutsOutputReference | DataAzurestackLbRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackLbRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackLbRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackLbRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule azurestack_lb_rule}
*/
export declare class DataAzurestackLbRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_lb_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/lb_rule azurestack_lb_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackLbRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackLbRuleConfig);
    get backendAddressPoolId(): string;
    get backendPort(): number;
    get disableOutboundSnat(): cdktf.IResolvable;
    get enableFloatingIp(): cdktf.IResolvable;
    get frontendIpConfigurationName(): string;
    get frontendPort(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idleTimeoutInMinutes(): number;
    get loadDistribution(): string;
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get probeId(): string;
    get protocol(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurestackLbRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackLbRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackLbRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
