import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackLbBackendAddressPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_backend_address_pool#id DataAzurestackLbBackendAddressPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_backend_address_pool#loadbalancer_id DataAzurestackLbBackendAddressPool#loadbalancer_id}
    */
    readonly loadbalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_backend_address_pool#name DataAzurestackLbBackendAddressPool#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_backend_address_pool#timeouts DataAzurestackLbBackendAddressPool#timeouts}
    */
    readonly timeouts?: DataAzurestackLbBackendAddressPoolTimeouts;
}
export interface DataAzurestackLbBackendAddressPoolBackendIpConfigurations {
}
export declare function dataAzurestackLbBackendAddressPoolBackendIpConfigurationsToTerraform(struct?: DataAzurestackLbBackendAddressPoolBackendIpConfigurations): any;
export declare class DataAzurestackLbBackendAddressPoolBackendIpConfigurationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackLbBackendAddressPoolBackendIpConfigurations | undefined;
    set internalValue(value: DataAzurestackLbBackendAddressPoolBackendIpConfigurations | undefined);
    get id(): string;
}
export declare class DataAzurestackLbBackendAddressPoolBackendIpConfigurationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackLbBackendAddressPoolBackendIpConfigurationsOutputReference;
}
export interface DataAzurestackLbBackendAddressPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb_backend_address_pool#read DataAzurestackLbBackendAddressPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackLbBackendAddressPoolTimeoutsToTerraform(struct?: DataAzurestackLbBackendAddressPoolTimeoutsOutputReference | DataAzurestackLbBackendAddressPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackLbBackendAddressPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackLbBackendAddressPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackLbBackendAddressPoolTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/lb_backend_address_pool azurestack_lb_backend_address_pool}
*/
export declare class DataAzurestackLbBackendAddressPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_lb_backend_address_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/lb_backend_address_pool azurestack_lb_backend_address_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackLbBackendAddressPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackLbBackendAddressPoolConfig);
    private _backendIpConfigurations;
    get backendIpConfigurations(): DataAzurestackLbBackendAddressPoolBackendIpConfigurationsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get loadBalancingRules(): string[];
    private _loadbalancerId?;
    get loadbalancerId(): string;
    set loadbalancerId(value: string);
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurestackLbBackendAddressPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackLbBackendAddressPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackLbBackendAddressPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
