import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackKeyVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault#id DataAzurestackKeyVault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault#name DataAzurestackKeyVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault#resource_group_name DataAzurestackKeyVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault#timeouts DataAzurestackKeyVault#timeouts}
    */
    readonly timeouts?: DataAzurestackKeyVaultTimeouts;
}
export interface DataAzurestackKeyVaultAccessPolicy {
}
export declare function dataAzurestackKeyVaultAccessPolicyToTerraform(struct?: DataAzurestackKeyVaultAccessPolicy): any;
export declare class DataAzurestackKeyVaultAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackKeyVaultAccessPolicy | undefined;
    set internalValue(value: DataAzurestackKeyVaultAccessPolicy | undefined);
    get applicationId(): string;
    get certificatePermissions(): string[];
    get keyPermissions(): string[];
    get objectId(): string;
    get secretPermissions(): string[];
    get storagePermissions(): string[];
    get tenantId(): string;
}
export declare class DataAzurestackKeyVaultAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackKeyVaultAccessPolicyOutputReference;
}
export interface DataAzurestackKeyVaultNetworkAcls {
}
export declare function dataAzurestackKeyVaultNetworkAclsToTerraform(struct?: DataAzurestackKeyVaultNetworkAcls): any;
export declare class DataAzurestackKeyVaultNetworkAclsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackKeyVaultNetworkAcls | undefined;
    set internalValue(value: DataAzurestackKeyVaultNetworkAcls | undefined);
    get bypass(): string;
    get defaultAction(): string;
    get ipRules(): string[];
    get virtualNetworkSubnetIds(): string[];
}
export declare class DataAzurestackKeyVaultNetworkAclsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackKeyVaultNetworkAclsOutputReference;
}
export interface DataAzurestackKeyVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault#read DataAzurestackKeyVault#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackKeyVaultTimeoutsToTerraform(struct?: DataAzurestackKeyVaultTimeoutsOutputReference | DataAzurestackKeyVaultTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackKeyVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackKeyVaultTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackKeyVaultTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault azurestack_key_vault}
*/
export declare class DataAzurestackKeyVault extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_key_vault";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/key_vault azurestack_key_vault} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackKeyVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackKeyVaultConfig);
    private _accessPolicy;
    get accessPolicy(): DataAzurestackKeyVaultAccessPolicyList;
    get enabledForDeployment(): cdktf.IResolvable;
    get enabledForDiskEncryption(): cdktf.IResolvable;
    get enabledForTemplateDeployment(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkAcls;
    get networkAcls(): DataAzurestackKeyVaultNetworkAclsList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get tenantId(): string;
    get vaultUri(): string;
    private _timeouts;
    get timeouts(): DataAzurestackKeyVaultTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackKeyVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackKeyVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
