import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackAvailabilitySetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/availability_set#id DataAzurestackAvailabilitySet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/availability_set#name DataAzurestackAvailabilitySet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/availability_set#resource_group_name DataAzurestackAvailabilitySet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/availability_set#timeouts DataAzurestackAvailabilitySet#timeouts}
    */
    readonly timeouts?: DataAzurestackAvailabilitySetTimeouts;
}
export interface DataAzurestackAvailabilitySetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/availability_set#read DataAzurestackAvailabilitySet#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackAvailabilitySetTimeoutsToTerraform(struct?: DataAzurestackAvailabilitySetTimeoutsOutputReference | DataAzurestackAvailabilitySetTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackAvailabilitySetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackAvailabilitySetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackAvailabilitySetTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/availability_set azurestack_availability_set}
*/
export declare class DataAzurestackAvailabilitySet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_availability_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/availability_set azurestack_availability_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackAvailabilitySetConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackAvailabilitySetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    get managed(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformFaultDomainCount(): string;
    get platformUpdateDomainCount(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackAvailabilitySetTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackAvailabilitySetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackAvailabilitySetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
