# Generated by Django 3.0.6 on 2020-06-19 00:44

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('customers', '0001_initial'),
        ('commons', '0001_initial'),
        ('masterdata', '0001_initial'),
        ('viewflow', '0008_jsonfield_and_artifact'),
    ]

    operations = [
        migrations.CreateModel(
            name='Employment',
            fields=[
                ('process_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='viewflow.Process')),
                ('begin', models.DateField(blank=True, default=None, null=True, verbose_name='kezdet')),
                ('end', models.DateField(blank=True, default=None, null=True, verbose_name='vég')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='commons.Person', verbose_name='munkavállaló')),
                ('employer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='customers.Customer', verbose_name='foglalkoztató')),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='masterdata.ApplianceQuality', verbose_name='Alkalmazás minősége')),
            ],
            options={
                'verbose_name': 'alkalmazott',
                'verbose_name_plural': 'alkalmazottak',
                'db_table': 'employments',
            },
            bases=('viewflow.process', models.Model),
        ),
        migrations.CreateModel(
            name='Payroll',
            fields=[
                ('process_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='viewflow.Process')),
                ('current_month', models.PositiveSmallIntegerField(verbose_name='tárgyhó')),
                ('current_year', models.PositiveIntegerField(verbose_name='tárgyév')),
                ('submitted', models.NullBooleanField(help_text='hatóság felé elküldve', verbose_name='elküldve')),
                ('employee', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='labor.Employment', verbose_name='alkalmazott')),
                ('employer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='customers.Customer', verbose_name='foglalkoztató')),
            ],
            options={
                'verbose_name': 'bérszámfejtés',
                'verbose_name_plural': 'bérszámfejtések',
                'db_table': 'payrolls',
            },
            bases=('viewflow.process', models.Model),
        ),
        migrations.CreateModel(
            name='Dependence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('begin', models.DateField(blank=True, default=None, null=True, verbose_name='kezdet')),
                ('end', models.DateField(blank=True, default=None, null=True, verbose_name='vég')),
                ('dependent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dependents', to='commons.Person', verbose_name='eltartott')),
                ('provider', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='providers', to='labor.Employment', verbose_name='eltartó')),
                ('quality', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='masterdata.DependentQuality', verbose_name='eltartott minőség')),
                ('right', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='masterdata.DependentRight', verbose_name='eltartott jogosultság')),
            ],
            options={
                'verbose_name': 'eltartott',
                'verbose_name_plural': 'eltartottak',
                'db_table': 'dependents',
            },
        ),
    ]
