# Generated by Django 3.0.6 on 2020-06-19 00:44

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('commons', '0001_initial'),
        ('viewflow', '0008_jsonfield_and_artifact'),
        ('masterdata', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=500, null=True, verbose_name='megnevezés')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnsubscriptionProcess',
            fields=[
                ('process_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='viewflow.Process')),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='customers.Customer', verbose_name='vállalkozás')),
            ],
            options={
                'verbose_name': 'kiléptetés',
                'verbose_name_plural': 'kiléptetések',
                'db_table': 'process_unsubscription',
            },
            bases=('viewflow.process',),
        ),
        migrations.CreateModel(
            name='SubscriptionProcess',
            fields=[
                ('process_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='viewflow.Process')),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='customers.Customer', verbose_name='vállalkozás')),
            ],
            options={
                'verbose_name': 'beléptetés',
                'verbose_name_plural': 'beléptetések',
                'db_table': 'process_subscription',
            },
            bases=('viewflow.process',),
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('customer_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, to='customers.Customer')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='törzsszám')),
                ('registration_number', models.CharField(max_length=500, verbose_name='cégjegyzékszám')),
                ('tax_number', models.CharField(max_length=20, verbose_name='adószám')),
                ('business_form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='organizations', to='masterdata.BusinessForm', verbose_name='cégforma')),
                ('manager', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='managers', to='commons.Person', verbose_name='ügyvezető')),
            ],
            options={
                'verbose_name': 'társas vállalkozás',
                'verbose_name_plural': 'társas vállalkozások',
                'db_table': 'organizations',
            },
            bases=('customers.customer', models.Model),
        ),
        migrations.CreateModel(
            name='Individual',
            fields=[
                ('customer_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, to='customers.Customer')),
                ('prime_number', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, verbose_name='törzsszám')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='persons', to='commons.Person', verbose_name='személyi adatok')),
            ],
            options={
                'verbose_name': 'egyéni vállalkozás',
                'verbose_name_plural': 'egyéni vállalkozások',
                'db_table': 'individuals',
            },
            bases=('customers.customer', models.Model),
        ),
    ]
