# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2018- 2023.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class ExperimentStatusExperiments(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, submitted_at=None, finished_at=None, current_at=None, current_iteration=None, total_iterations=None, state=None, message=None, failure=None):
        """
        ExperimentStatusExperiments - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'submitted_at': 'datetime',
            'finished_at': 'datetime',
            'current_at': 'datetime',
            'current_iteration': 'float',
            'total_iterations': 'float',
            'state': 'str',
            'message': 'str',
            'failure': 'ErrorSchemaExperiments'
        }

        self.attribute_map = {
            'submitted_at': 'submitted_at',
            'finished_at': 'finished_at',
            'current_at': 'current_at',
            'current_iteration': 'current_iteration',
            'total_iterations': 'total_iterations',
            'state': 'state',
            'message': 'message',
            'failure': 'failure'
        }

        self._submitted_at = submitted_at
        self._finished_at = finished_at
        self._current_at = current_at
        self._current_iteration = current_iteration
        self._total_iterations = total_iterations
        self._state = state
        self._message = message
        self._failure = failure

    @property
    def submitted_at(self):
        """
        Gets the submitted_at of this ExperimentStatusExperiments.


        :return: The submitted_at of this ExperimentStatusExperiments.
        :rtype: datetime
        """
        return self._submitted_at

    @submitted_at.setter
    def submitted_at(self, submitted_at):
        """
        Sets the submitted_at of this ExperimentStatusExperiments.


        :param submitted_at: The submitted_at of this ExperimentStatusExperiments.
        :type: datetime
        """

        self._submitted_at = submitted_at

    @property
    def finished_at(self):
        """
        Gets the finished_at of this ExperimentStatusExperiments.


        :return: The finished_at of this ExperimentStatusExperiments.
        :rtype: datetime
        """
        return self._finished_at

    @finished_at.setter
    def finished_at(self, finished_at):
        """
        Sets the finished_at of this ExperimentStatusExperiments.


        :param finished_at: The finished_at of this ExperimentStatusExperiments.
        :type: datetime
        """

        self._finished_at = finished_at

    @property
    def current_at(self):
        """
        Gets the current_at of this ExperimentStatusExperiments.


        :return: The current_at of this ExperimentStatusExperiments.
        :rtype: datetime
        """
        return self._current_at

    @current_at.setter
    def current_at(self, current_at):
        """
        Sets the current_at of this ExperimentStatusExperiments.


        :param current_at: The current_at of this ExperimentStatusExperiments.
        :type: datetime
        """

        self._current_at = current_at

    @property
    def current_iteration(self):
        """
        Gets the current_iteration of this ExperimentStatusExperiments.


        :return: The current_iteration of this ExperimentStatusExperiments.
        :rtype: float
        """
        return self._current_iteration

    @current_iteration.setter
    def current_iteration(self, current_iteration):
        """
        Sets the current_iteration of this ExperimentStatusExperiments.


        :param current_iteration: The current_iteration of this ExperimentStatusExperiments.
        :type: float
        """

        self._current_iteration = current_iteration

    @property
    def total_iterations(self):
        """
        Gets the total_iterations of this ExperimentStatusExperiments.


        :return: The total_iterations of this ExperimentStatusExperiments.
        :rtype: float
        """
        return self._total_iterations

    @total_iterations.setter
    def total_iterations(self, total_iterations):
        """
        Sets the total_iterations of this ExperimentStatusExperiments.


        :param total_iterations: The total_iterations of this ExperimentStatusExperiments.
        :type: float
        """

        self._total_iterations = total_iterations

    @property
    def state(self):
        """
        Gets the state of this ExperimentStatusExperiments.


        :return: The state of this ExperimentStatusExperiments.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this ExperimentStatusExperiments.


        :param state: The state of this ExperimentStatusExperiments.
        :type: str
        """
        allowed_values = ["running", "completed", "failed", "canceled"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def message(self):
        """
        Gets the message of this ExperimentStatusExperiments.


        :return: The message of this ExperimentStatusExperiments.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ExperimentStatusExperiments.


        :param message: The message of this ExperimentStatusExperiments.
        :type: str
        """

        self._message = message

    @property
    def failure(self):
        """
        Gets the failure of this ExperimentStatusExperiments.


        :return: The failure of this ExperimentStatusExperiments.
        :rtype: ErrorSchemaExperiments
        """
        return self._failure

    @failure.setter
    def failure(self, failure):
        """
        Sets the failure of this ExperimentStatusExperiments.


        :param failure: The failure of this ExperimentStatusExperiments.
        :type: ErrorSchemaExperiments
        """

        self._failure = failure

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
