# Copyright (C) 2022 PlanQK
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
"""This module contains all predefined classes to configure startup, i.e. how
the initial population of a genetic algorithm is created.

A good starting population can decrease runtime performance, if the individuals
are already good, and increase solution quality of it is diverse.

"""

from .startup import Startup
from .random_startup import RandomStartup
from .warm_startup import WarmStartup
from .sampling_startup import SamplingStartup
