# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.monitoring_dashboard import gapic_version as package_version

__version__ = package_version.__version__


from .services.dashboards_service import DashboardsServiceClient
from .services.dashboards_service import DashboardsServiceAsyncClient

from .types.alertchart import AlertChart
from .types.collapsible_group import CollapsibleGroup
from .types.common import Aggregation
from .types.common import PickTimeSeriesFilter
from .types.common import StatisticalTimeSeriesFilter
from .types.dashboard import Dashboard
from .types.dashboard_filter import DashboardFilter
from .types.dashboards_service import CreateDashboardRequest
from .types.dashboards_service import DeleteDashboardRequest
from .types.dashboards_service import GetDashboardRequest
from .types.dashboards_service import ListDashboardsRequest
from .types.dashboards_service import ListDashboardsResponse
from .types.dashboards_service import UpdateDashboardRequest
from .types.layouts import ColumnLayout
from .types.layouts import GridLayout
from .types.layouts import MosaicLayout
from .types.layouts import RowLayout
from .types.logs_panel import LogsPanel
from .types.metrics import Threshold
from .types.metrics import TimeSeriesFilter
from .types.metrics import TimeSeriesFilterRatio
from .types.metrics import TimeSeriesQuery
from .types.metrics import SparkChartType
from .types.scorecard import Scorecard
from .types.table import TimeSeriesTable
from .types.table_display_options import TableDisplayOptions
from .types.text import Text
from .types.widget import Widget
from .types.xychart import ChartOptions
from .types.xychart import XyChart

__all__ = (
    "DashboardsServiceAsyncClient",
    "Aggregation",
    "AlertChart",
    "ChartOptions",
    "CollapsibleGroup",
    "ColumnLayout",
    "CreateDashboardRequest",
    "Dashboard",
    "DashboardFilter",
    "DashboardsServiceClient",
    "DeleteDashboardRequest",
    "GetDashboardRequest",
    "GridLayout",
    "ListDashboardsRequest",
    "ListDashboardsResponse",
    "LogsPanel",
    "MosaicLayout",
    "PickTimeSeriesFilter",
    "RowLayout",
    "Scorecard",
    "SparkChartType",
    "StatisticalTimeSeriesFilter",
    "TableDisplayOptions",
    "Text",
    "Threshold",
    "TimeSeriesFilter",
    "TimeSeriesFilterRatio",
    "TimeSeriesQuery",
    "TimeSeriesTable",
    "UpdateDashboardRequest",
    "Widget",
    "XyChart",
)
