"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
async function handler(event) {
    var _a, _b;
    const response = event.Records[0].cf.response;
    if (!((_b = (_a = response.headers['x-amz-website-redirect-location']) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.value)) {
        return response;
    }
    return {
        status: '301',
        statusDescription: 'Moved Permanently',
        body: '',
        headers: {
            location: [{
                    key: 'Location',
                    value: response.headers['x-amz-website-redirect-location'][0].value,
                }],
        },
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVkaXJlY3QuZWRnZS1sYW1iZGEuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvdXJsLXNob3J0ZW5lci9yZWRpcmVjdC5lZGdlLWxhbWJkYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBTyxLQUFLLFVBQVUsT0FBTyxDQUFDLEtBQXdDOztJQUNwRSxNQUFNLFFBQVEsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUM7SUFFOUMsSUFBSSxjQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsaUNBQWlDLENBQUMsMENBQUcsQ0FBQywyQ0FBRyxLQUFLLENBQUEsRUFBRTtRQUNwRSxPQUFPLFFBQVEsQ0FBQztLQUNqQjtJQUVELE9BQU87UUFDTCxNQUFNLEVBQUUsS0FBSztRQUNiLGlCQUFpQixFQUFFLG1CQUFtQjtRQUN0QyxJQUFJLEVBQUUsRUFBRTtRQUNSLE9BQU8sRUFBRTtZQUNQLFFBQVEsRUFBRSxDQUFDO29CQUNULEdBQUcsRUFBRSxVQUFVO29CQUNmLEtBQUssRUFBRSxRQUFRLENBQUMsT0FBTyxDQUFDLGlDQUFpQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSztpQkFDcEUsQ0FBQztTQUNIO0tBQ0YsQ0FBQztBQUNKLENBQUM7QUFsQkQsMEJBa0JDIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZXIoZXZlbnQ6IEFXU0xhbWJkYS5DbG91ZEZyb250UmVzcG9uc2VFdmVudCk6IFByb21pc2U8QVdTTGFtYmRhLkNsb3VkRnJvbnRSZXNwb25zZVJlc3VsdD4ge1xuICBjb25zdCByZXNwb25zZSA9IGV2ZW50LlJlY29yZHNbMF0uY2YucmVzcG9uc2U7XG5cbiAgaWYgKCFyZXNwb25zZS5oZWFkZXJzWyd4LWFtei13ZWJzaXRlLXJlZGlyZWN0LWxvY2F0aW9uJ10/LlswXT8udmFsdWUpIHtcbiAgICByZXR1cm4gcmVzcG9uc2U7XG4gIH1cblxuICByZXR1cm4ge1xuICAgIHN0YXR1czogJzMwMScsXG4gICAgc3RhdHVzRGVzY3JpcHRpb246ICdNb3ZlZCBQZXJtYW5lbnRseScsXG4gICAgYm9keTogJycsXG4gICAgaGVhZGVyczoge1xuICAgICAgbG9jYXRpb246IFt7XG4gICAgICAgIGtleTogJ0xvY2F0aW9uJyxcbiAgICAgICAgdmFsdWU6IHJlc3BvbnNlLmhlYWRlcnNbJ3gtYW16LXdlYnNpdGUtcmVkaXJlY3QtbG9jYXRpb24nXVswXS52YWx1ZSxcbiAgICAgIH1dLFxuICAgIH0sXG4gIH07XG59XG4iXX0=