import { Duration } from 'aws-cdk-lib';
import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import * as route53 from 'aws-cdk-lib/aws-route53';
import { Construct } from 'constructs';
/**
 * Properties for a UrlShortener
 */
export interface UrlShortenerProps {
    /**
     * The hosted zone for the short URLs domain
     */
    readonly hostedZone: route53.IHostedZone;
    /**
     * The record name to use in the hosted zone
     *
     * @default - zone root
     */
    readonly recordName?: string;
    /**
     * Expiration for short urls
     *
     * @default cdk.Duration.days(365)
     */
    readonly expiration?: Duration;
    /**
     * An interface VPC endpoint for API gateway. Specifying this property will
     * make the API private.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-private-apis.html
     *
     * @default - API is public
     */
    readonly apiGatewayEndpoint?: ec2.IInterfaceVpcEndpoint;
    /**
     * Authorizer for API gateway.
     *
     * @default - do not use an authorizer for the API
     */
    readonly apiGatewayAuthorizer?: apigateway.IAuthorizer;
    /**
     * Allowed origins for CORS
     *
     * @default - CORS is not enabled
     */
    readonly corsAllowOrigins?: string[];
}
/**
 * URL shortener
 */
export declare class UrlShortener extends Construct {
    /**
     * The endpoint of the URL shortener API
     */
    readonly apiEndpoint: string;
    /**
     * The underlying API Gateway REST API
     */
    readonly api: apigateway.LambdaRestApi;
    constructor(scope: Construct, id: string, props: UrlShortenerProps);
}
