var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/url-shortener/shortener.lambda.ts
var shortener_lambda_exports = {};
__export(shortener_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(shortener_lambda_exports);
var import_aws_sdk = require("aws-sdk");
function base62Encode(int) {
  const characterSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  if (int === 0)
    return "0";
  let s = "";
  while (int > 0) {
    s = characterSet[int % 62] + s;
    int = Math.floor(int / 62);
  }
  return s;
}
function getEnv(name) {
  const value = process.env[name];
  if (!value) {
    throw new Error(`The environment variable ${name} is not defined`);
  }
  return value;
}
var documentClient = new import_aws_sdk.DynamoDB.DocumentClient({ apiVersion: "2012-08-10" });
var s3 = new import_aws_sdk.S3({ apiVersion: "2006-03-01" });
async function handler(event) {
  var _a;
  console.log("Event: %j", event);
  const response = {
    statusCode: 201,
    body: "",
    headers: process.env.CORS_ALLOW_ORIGINS ? { "Access-Control-Allow-Origin": process.env.CORS_ALLOW_ORIGINS } : void 0
  };
  try {
    const body = JSON.parse(event.body ?? "{}");
    if (!body.url) {
      return __spreadProps(__spreadValues({}, response), {
        statusCode: 400
      });
    }
    const update = await documentClient.update({
      TableName: getEnv("TABLE_NAME"),
      Key: { key: "counter" },
      UpdateExpression: "ADD #value :incr",
      ExpressionAttributeNames: { "#value": "value" },
      ExpressionAttributeValues: { ":incr": 1 },
      ReturnValues: "UPDATED_NEW"
    }).promise();
    const value = (_a = update.Attributes) == null ? void 0 : _a.value;
    if (!value) {
      throw new Error("Cannot get next counter value");
    }
    const key = base62Encode(value);
    console.log("Key: %j", key);
    const putObject = await s3.putObject({
      Bucket: getEnv("BUCKET_NAME"),
      Key: key,
      WebsiteRedirectLocation: body.url
    }).promise();
    console.log("Put object: %j", putObject);
    return __spreadProps(__spreadValues({}, response), {
      body: JSON.stringify({
        url: body.url,
        shortUrl: `https://${getEnv("DOMAIN_NAME")}/${key}`
      })
    });
  } catch (err) {
    console.log(err);
    return __spreadProps(__spreadValues({}, response), {
      statusCode: 500
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
