import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::CustomerProfiles::Domain`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html
 */
export interface CfnDomainProps {
    /**
     * `AWS::CustomerProfiles::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::CustomerProfiles::Domain.DeadLetterQueueUrl`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-deadletterqueueurl
     */
    readonly deadLetterQueueUrl?: string;
    /**
     * `AWS::CustomerProfiles::Domain.DefaultEncryptionKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultencryptionkey
     */
    readonly defaultEncryptionKey?: string;
    /**
     * `AWS::CustomerProfiles::Domain.DefaultExpirationDays`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultexpirationdays
     */
    readonly defaultExpirationDays?: number;
    /**
     * `AWS::CustomerProfiles::Domain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Domain`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Domain
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CustomerProfiles::Domain";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDomain;
    /**
     * @external
     * @cloudformationAttribute CreatedAt
     */
    readonly attrCreatedAt: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedAt
     */
    readonly attrLastUpdatedAt: string;
    /**
     * `AWS::CustomerProfiles::Domain.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-domainname
     */
    domainName: string;
    /**
     * `AWS::CustomerProfiles::Domain.DeadLetterQueueUrl`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-deadletterqueueurl
     */
    deadLetterQueueUrl: string | undefined;
    /**
     * `AWS::CustomerProfiles::Domain.DefaultEncryptionKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultencryptionkey
     */
    defaultEncryptionKey: string | undefined;
    /**
     * `AWS::CustomerProfiles::Domain.DefaultExpirationDays`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-defaultexpirationdays
     */
    defaultExpirationDays: number | undefined;
    /**
     * `AWS::CustomerProfiles::Domain.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-domain.html#cfn-customerprofiles-domain-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CustomerProfiles::Domain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDomainProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export interface CfnIntegrationProps {
    /**
     * `AWS::CustomerProfiles::Integration.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::CustomerProfiles::Integration.ObjectTypeName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypename
     */
    readonly objectTypeName: string;
    /**
     * `AWS::CustomerProfiles::Integration.FlowDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition
     */
    readonly flowDefinition?: CfnIntegration.FlowDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::CustomerProfiles::Integration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CustomerProfiles::Integration.Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-uri
     */
    readonly uri?: string;
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare class CfnIntegration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CustomerProfiles::Integration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnIntegration;
    /**
     * @external
     * @cloudformationAttribute CreatedAt
     */
    readonly attrCreatedAt: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedAt
     */
    readonly attrLastUpdatedAt: string;
    /**
     * `AWS::CustomerProfiles::Integration.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-domainname
     */
    domainName: string;
    /**
     * `AWS::CustomerProfiles::Integration.ObjectTypeName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-objecttypename
     */
    objectTypeName: string;
    /**
     * `AWS::CustomerProfiles::Integration.FlowDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-flowdefinition
     */
    flowDefinition: CfnIntegration.FlowDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CustomerProfiles::Integration.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CustomerProfiles::Integration.Uri`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html#cfn-customerprofiles-integration-uri
     */
    uri: string | undefined;
    /**
     * Create a new `AWS::CustomerProfiles::Integration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIntegrationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html
     */
    interface ConnectorOperatorProperty {
        /**
         * `CfnIntegration.ConnectorOperatorProperty.Marketo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-marketo
         */
        readonly marketo?: string;
        /**
         * `CfnIntegration.ConnectorOperatorProperty.S3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-s3
         */
        readonly s3?: string;
        /**
         * `CfnIntegration.ConnectorOperatorProperty.Salesforce`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-salesforce
         */
        readonly salesforce?: string;
        /**
         * `CfnIntegration.ConnectorOperatorProperty.ServiceNow`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-servicenow
         */
        readonly serviceNow?: string;
        /**
         * `CfnIntegration.ConnectorOperatorProperty.Zendesk`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-connectoroperator.html#cfn-customerprofiles-integration-connectoroperator-zendesk
         */
        readonly zendesk?: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html
     */
    interface FlowDefinitionProperty {
        /**
         * `CfnIntegration.FlowDefinitionProperty.Description`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-description
         */
        readonly description?: string;
        /**
         * `CfnIntegration.FlowDefinitionProperty.FlowName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-flowname
         */
        readonly flowName: string;
        /**
         * `CfnIntegration.FlowDefinitionProperty.KmsArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-kmsarn
         */
        readonly kmsArn: string;
        /**
         * `CfnIntegration.FlowDefinitionProperty.SourceFlowConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-sourceflowconfig
         */
        readonly sourceFlowConfig: CfnIntegration.SourceFlowConfigProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.FlowDefinitionProperty.Tasks`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-tasks
         */
        readonly tasks: Array<CfnIntegration.TaskProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnIntegration.FlowDefinitionProperty.TriggerConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-flowdefinition.html#cfn-customerprofiles-integration-flowdefinition-triggerconfig
         */
        readonly triggerConfig: CfnIntegration.TriggerConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-incrementalpullconfig.html
     */
    interface IncrementalPullConfigProperty {
        /**
         * `CfnIntegration.IncrementalPullConfigProperty.DatetimeTypeFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-incrementalpullconfig.html#cfn-customerprofiles-integration-incrementalpullconfig-datetimetypefieldname
         */
        readonly datetimeTypeFieldName?: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-marketosourceproperties.html
     */
    interface MarketoSourcePropertiesProperty {
        /**
         * `CfnIntegration.MarketoSourcePropertiesProperty.Object`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-marketosourceproperties.html#cfn-customerprofiles-integration-marketosourceproperties-object
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html
     */
    interface S3SourcePropertiesProperty {
        /**
         * `CfnIntegration.S3SourcePropertiesProperty.BucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html#cfn-customerprofiles-integration-s3sourceproperties-bucketname
         */
        readonly bucketName: string;
        /**
         * `CfnIntegration.S3SourcePropertiesProperty.BucketPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-s3sourceproperties.html#cfn-customerprofiles-integration-s3sourceproperties-bucketprefix
         */
        readonly bucketPrefix?: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html
     */
    interface SalesforceSourcePropertiesProperty {
        /**
         * `CfnIntegration.SalesforceSourcePropertiesProperty.EnableDynamicFieldUpdate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-enabledynamicfieldupdate
         */
        readonly enableDynamicFieldUpdate?: boolean | cdk.IResolvable;
        /**
         * `CfnIntegration.SalesforceSourcePropertiesProperty.IncludeDeletedRecords`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-includedeletedrecords
         */
        readonly includeDeletedRecords?: boolean | cdk.IResolvable;
        /**
         * `CfnIntegration.SalesforceSourcePropertiesProperty.Object`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-salesforcesourceproperties.html#cfn-customerprofiles-integration-salesforcesourceproperties-object
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html
     */
    interface ScheduledTriggerPropertiesProperty {
        /**
         * `CfnIntegration.ScheduledTriggerPropertiesProperty.DataPullMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-datapullmode
         */
        readonly dataPullMode?: string;
        /**
         * `CfnIntegration.ScheduledTriggerPropertiesProperty.FirstExecutionFrom`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-firstexecutionfrom
         */
        readonly firstExecutionFrom?: number;
        /**
         * `CfnIntegration.ScheduledTriggerPropertiesProperty.ScheduleEndTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleendtime
         */
        readonly scheduleEndTime?: number;
        /**
         * `CfnIntegration.ScheduledTriggerPropertiesProperty.ScheduleExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleexpression
         */
        readonly scheduleExpression: string;
        /**
         * `CfnIntegration.ScheduledTriggerPropertiesProperty.ScheduleOffset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-scheduleoffset
         */
        readonly scheduleOffset?: number;
        /**
         * `CfnIntegration.ScheduledTriggerPropertiesProperty.ScheduleStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-schedulestarttime
         */
        readonly scheduleStartTime?: number;
        /**
         * `CfnIntegration.ScheduledTriggerPropertiesProperty.Timezone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-scheduledtriggerproperties.html#cfn-customerprofiles-integration-scheduledtriggerproperties-timezone
         */
        readonly timezone?: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-servicenowsourceproperties.html
     */
    interface ServiceNowSourcePropertiesProperty {
        /**
         * `CfnIntegration.ServiceNowSourcePropertiesProperty.Object`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-servicenowsourceproperties.html#cfn-customerprofiles-integration-servicenowsourceproperties-object
         */
        readonly object: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html
     */
    interface SourceConnectorPropertiesProperty {
        /**
         * `CfnIntegration.SourceConnectorPropertiesProperty.Marketo`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-marketo
         */
        readonly marketo?: CfnIntegration.MarketoSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.SourceConnectorPropertiesProperty.S3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-s3
         */
        readonly s3?: CfnIntegration.S3SourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.SourceConnectorPropertiesProperty.Salesforce`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-salesforce
         */
        readonly salesforce?: CfnIntegration.SalesforceSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.SourceConnectorPropertiesProperty.ServiceNow`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-servicenow
         */
        readonly serviceNow?: CfnIntegration.ServiceNowSourcePropertiesProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.SourceConnectorPropertiesProperty.Zendesk`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceconnectorproperties.html#cfn-customerprofiles-integration-sourceconnectorproperties-zendesk
         */
        readonly zendesk?: CfnIntegration.ZendeskSourcePropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html
     */
    interface SourceFlowConfigProperty {
        /**
         * `CfnIntegration.SourceFlowConfigProperty.ConnectorProfileName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-connectorprofilename
         */
        readonly connectorProfileName?: string;
        /**
         * `CfnIntegration.SourceFlowConfigProperty.ConnectorType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-connectortype
         */
        readonly connectorType: string;
        /**
         * `CfnIntegration.SourceFlowConfigProperty.IncrementalPullConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-incrementalpullconfig
         */
        readonly incrementalPullConfig?: CfnIntegration.IncrementalPullConfigProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.SourceFlowConfigProperty.SourceConnectorProperties`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-sourceflowconfig.html#cfn-customerprofiles-integration-sourceflowconfig-sourceconnectorproperties
         */
        readonly sourceConnectorProperties: CfnIntegration.SourceConnectorPropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html
     */
    interface TaskProperty {
        /**
         * `CfnIntegration.TaskProperty.ConnectorOperator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-connectoroperator
         */
        readonly connectorOperator?: CfnIntegration.ConnectorOperatorProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.TaskProperty.DestinationField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-destinationfield
         */
        readonly destinationField?: string;
        /**
         * `CfnIntegration.TaskProperty.SourceFields`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-sourcefields
         */
        readonly sourceFields: string[];
        /**
         * `CfnIntegration.TaskProperty.TaskProperties`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-taskproperties
         */
        readonly taskProperties?: Array<CfnIntegration.TaskPropertiesMapProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnIntegration.TaskProperty.TaskType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-task.html#cfn-customerprofiles-integration-task-tasktype
         */
        readonly taskType: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html
     */
    interface TaskPropertiesMapProperty {
        /**
         * `CfnIntegration.TaskPropertiesMapProperty.OperatorPropertyKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html#cfn-customerprofiles-integration-taskpropertiesmap-operatorpropertykey
         */
        readonly operatorPropertyKey: string;
        /**
         * `CfnIntegration.TaskPropertiesMapProperty.Property`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-taskpropertiesmap.html#cfn-customerprofiles-integration-taskpropertiesmap-property
         */
        readonly property: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html
     */
    interface TriggerConfigProperty {
        /**
         * `CfnIntegration.TriggerConfigProperty.TriggerProperties`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html#cfn-customerprofiles-integration-triggerconfig-triggerproperties
         */
        readonly triggerProperties?: CfnIntegration.TriggerPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnIntegration.TriggerConfigProperty.TriggerType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerconfig.html#cfn-customerprofiles-integration-triggerconfig-triggertype
         */
        readonly triggerType: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerproperties.html
     */
    interface TriggerPropertiesProperty {
        /**
         * `CfnIntegration.TriggerPropertiesProperty.Scheduled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-triggerproperties.html#cfn-customerprofiles-integration-triggerproperties-scheduled
         */
        readonly scheduled?: CfnIntegration.ScheduledTriggerPropertiesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::Integration`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::Integration
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-integration.html
 */
export declare namespace CfnIntegration {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-zendesksourceproperties.html
     */
    interface ZendeskSourcePropertiesProperty {
        /**
         * `CfnIntegration.ZendeskSourcePropertiesProperty.Object`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-integration-zendesksourceproperties.html#cfn-customerprofiles-integration-zendesksourceproperties-object
         */
        readonly object: string;
    }
}
/**
 * Properties for defining a `AWS::CustomerProfiles::ObjectType`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html
 */
export interface CfnObjectTypeProps {
    /**
     * `AWS::CustomerProfiles::ObjectType.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::CustomerProfiles::ObjectType.AllowProfileCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-allowprofilecreation
     */
    readonly allowProfileCreation?: boolean | cdk.IResolvable;
    /**
     * `AWS::CustomerProfiles::ObjectType.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-description
     */
    readonly description?: string;
    /**
     * `AWS::CustomerProfiles::ObjectType.EncryptionKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-encryptionkey
     */
    readonly encryptionKey?: string;
    /**
     * `AWS::CustomerProfiles::ObjectType.ExpirationDays`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-expirationdays
     */
    readonly expirationDays?: number;
    /**
     * `AWS::CustomerProfiles::ObjectType.Fields`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-fields
     */
    readonly fields?: Array<CfnObjectType.FieldMapProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CustomerProfiles::ObjectType.Keys`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-keys
     */
    readonly keys?: Array<CfnObjectType.KeyMapProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CustomerProfiles::ObjectType.ObjectTypeName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-objecttypename
     */
    readonly objectTypeName?: string;
    /**
     * `AWS::CustomerProfiles::ObjectType.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CustomerProfiles::ObjectType.TemplateId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-templateid
     */
    readonly templateId?: string;
}
/**
 * A CloudFormation `AWS::CustomerProfiles::ObjectType`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::ObjectType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html
 */
export declare class CfnObjectType extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CustomerProfiles::ObjectType";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnObjectType;
    /**
     * @external
     * @cloudformationAttribute CreatedAt
     */
    readonly attrCreatedAt: string;
    /**
     * @external
     * @cloudformationAttribute LastUpdatedAt
     */
    readonly attrLastUpdatedAt: string;
    /**
     * `AWS::CustomerProfiles::ObjectType.DomainName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-domainname
     */
    domainName: string;
    /**
     * `AWS::CustomerProfiles::ObjectType.AllowProfileCreation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-allowprofilecreation
     */
    allowProfileCreation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CustomerProfiles::ObjectType.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-description
     */
    description: string | undefined;
    /**
     * `AWS::CustomerProfiles::ObjectType.EncryptionKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-encryptionkey
     */
    encryptionKey: string | undefined;
    /**
     * `AWS::CustomerProfiles::ObjectType.ExpirationDays`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-expirationdays
     */
    expirationDays: number | undefined;
    /**
     * `AWS::CustomerProfiles::ObjectType.Fields`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-fields
     */
    fields: Array<CfnObjectType.FieldMapProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CustomerProfiles::ObjectType.Keys`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-keys
     */
    keys: Array<CfnObjectType.KeyMapProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CustomerProfiles::ObjectType.ObjectTypeName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-objecttypename
     */
    objectTypeName: string | undefined;
    /**
     * `AWS::CustomerProfiles::ObjectType.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CustomerProfiles::ObjectType.TemplateId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html#cfn-customerprofiles-objecttype-templateid
     */
    templateId: string | undefined;
    /**
     * Create a new `AWS::CustomerProfiles::ObjectType`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnObjectTypeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CustomerProfiles::ObjectType`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::ObjectType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html
 */
export declare namespace CfnObjectType {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-fieldmap.html
     */
    interface FieldMapProperty {
        /**
         * `CfnObjectType.FieldMapProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-fieldmap.html#cfn-customerprofiles-objecttype-fieldmap-name
         */
        readonly name?: string;
        /**
         * `CfnObjectType.FieldMapProperty.ObjectTypeField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-fieldmap.html#cfn-customerprofiles-objecttype-fieldmap-objecttypefield
         */
        readonly objectTypeField?: CfnObjectType.ObjectTypeFieldProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::ObjectType`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::ObjectType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html
 */
export declare namespace CfnObjectType {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-keymap.html
     */
    interface KeyMapProperty {
        /**
         * `CfnObjectType.KeyMapProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-keymap.html#cfn-customerprofiles-objecttype-keymap-name
         */
        readonly name?: string;
        /**
         * `CfnObjectType.KeyMapProperty.ObjectTypeKeyList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-keymap.html#cfn-customerprofiles-objecttype-keymap-objecttypekeylist
         */
        readonly objectTypeKeyList?: Array<CfnObjectType.ObjectTypeKeyProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::ObjectType`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::ObjectType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html
 */
export declare namespace CfnObjectType {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypefield.html
     */
    interface ObjectTypeFieldProperty {
        /**
         * `CfnObjectType.ObjectTypeFieldProperty.ContentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypefield.html#cfn-customerprofiles-objecttype-objecttypefield-contenttype
         */
        readonly contentType?: string;
        /**
         * `CfnObjectType.ObjectTypeFieldProperty.Source`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypefield.html#cfn-customerprofiles-objecttype-objecttypefield-source
         */
        readonly source?: string;
        /**
         * `CfnObjectType.ObjectTypeFieldProperty.Target`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypefield.html#cfn-customerprofiles-objecttype-objecttypefield-target
         */
        readonly target?: string;
    }
}
/**
 * A CloudFormation `AWS::CustomerProfiles::ObjectType`.
 *
 * @external
 * @cloudformationResource AWS::CustomerProfiles::ObjectType
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-objecttype.html
 */
export declare namespace CfnObjectType {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypekey.html
     */
    interface ObjectTypeKeyProperty {
        /**
         * `CfnObjectType.ObjectTypeKeyProperty.FieldNames`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypekey.html#cfn-customerprofiles-objecttype-objecttypekey-fieldnames
         */
        readonly fieldNames?: string[];
        /**
         * `CfnObjectType.ObjectTypeKeyProperty.StandardIdentifiers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-objecttype-objecttypekey.html#cfn-customerprofiles-objecttype-objecttypekey-standardidentifiers
         */
        readonly standardIdentifiers?: string[];
    }
}
