#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.obj',
  description = 'Convenience facilities for objects.',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20200318',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  include_package_data = True,
  install_requires = ['cs.py3'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description = '*Latest release 20200318*:\nReplace obsolete O class with a new subclass of SimpleNamespace which issues a warning.\nNew singleton() generic factory function and SingletonMixin mixin class for making singleton classes.\n\nConvenience facilities for objects.\n\nPresents:\n* flavour, for deciding whether an object resembles a mapping or sequence.\n* Some O_* functions for working with objects\n* Proxy, a very simple minded object proxy intended to aid debugging.\n\n## Function `copy(obj, *a, **kw)`\n\nConvenient function to shallow copy an object with simple modifications.\n\nPerforms a shallow copy of `self` using copy.copy.\n\nTreat all positional parameters as attribute names, and\nreplace those attributes with shallow copies of the original\nattribute.\n\nTreat all keyword arguments as (attribute,value) tuples and\nreplace those attributes with the supplied values.\n\n## Function `flavour(obj)`\n\nReturn constants indicating the ``flavour\'\' of an object:\n* `T_MAP`: DictType, DictionaryType, objects with an __keys__ or keys attribute.\n* `T_SEQ`: TupleType, ListType, objects with an __iter__ attribute.\n* `T_SCALAR`: Anything else.\n\n## Class `O(types.SimpleNamespace)`\n\nThe `O` class is now obsolete, please subclass `types.SimpleNamespace`.\n\n## Function `O_attritems(o)`\n\nGenerator yielding `(attr,value)` for relevant attributes of `o`.\n\n## Function `O_attrs(o)`\n\nYield attribute names from `o` which are pertinent to `O_str`.\n\nNote: this calls `getattr(o,attr)` to inspect it in order to\nprune callables.\n\n## Function `O_merge(o, _conflict=None, _overwrite=False, **kw)`\n\nMerge key:value pairs from a mapping into an object.\n\nIgnore keys that do not start with a letter.\nNew attributes or attributes whose values compare equal are\nmerged in. Unequal values are passed to:\n\n    _conflict(o, attr, old_value, new_value)\n\nto resolve the conflict. If _conflict is omitted or None\nthen the new value overwrites the old if _overwrite is true.\n\n## Function `O_str(o, no_recurse=False, seen=None)`\n\nReturn a `str` representation of the object `o`.\n\nParameters:\n* `o`: the object to describe.\n* `no_recurse`: if true, do not recurse into the object\'s structure.\n  Default: `False`.\n* `seen`: a set of previously sighted objects\n  to prevent recursion loops.\n\n## Function `obj_as_dict(o, attr_prefix=None, attr_match=None)`\n\nReturn a dictionary with keys mapping to `o` attributes.\n\n## Class `Proxy`\n\nAn extremely simple proxy object\nthat passes all unmatched attribute accesses to the proxied object.\n\nNote that setattr and delattr work directly on the proxy, not the proxied object.\n\n## Function `singleton(registry, key, factory, fargs, fkwargs)`\n\nObtain an object for `key` via `registry` (a mapping of `key`=>`object`.\n\nIf the `key` exists in the registry, return the associated object.\nOtherwise create a new object by calling `factory(*fargs,**fkwargs)`\nand store it as `key` in the `registry`.\n\nThe `registry` may be any mapping of `key`s to objects\nbut might usually be a `weakref.WeakValueMapping`\nto that object references expire as normal.\n\nSee the `SingletonMixin` class for a simple mixin to create\nsingleton classes.\n\n## Class `SingletonMixin`\n\nA mixin turning a subclass into a singleton factory.\n\n*Note*: this should be the *first* superclass of the subclass\nin order to intercept `__new__` and `__init__`.\n\nA subclass should:\n* *not* provide an `__init__` method.\n* provide a `_singleton_init` method in place of the normal `__init__`\n  with the usual signature `(self,*args,**kwargs)`.\n* provide a `_singleton_key(cls,*args,**kwargs)` class method\n  returning a key for the single registry\n  computed from the positional and keyword arguments\n  supplied on instance creation\n  i.e. those which `__init__` would normally receive.\n  This should have the same signature as `_singleton_init`\n  (but using `cls` instead of `self`).\n\nExample:\n\n    class Pool(SingletonMixin):\n\n        def _singleton_init(self, foo, bah=3):\n           ... normal __init__ stuff here ...\n\n        @classmethod\n        def _singleton_key(cls, foo, bah=3):\n            return foo, bah\n\n## Class `TrackedClassMixin`\n\nA mixin to track all instances of a particular class.\n\nThis is aimed at checking the global state of objects of a\nparticular type, particularly states like counters. The\ntracking is attached to the class itself.\n\nThe class to be tracked includes this mixin as a superclass and calls:\n\n    TrackedClassMixin.__init__(class_to_track)\n\nfrom its __init__ method. Note that `class_to_track` is\ntypically the class name itself, not `type(self)` which would\ntrack the specific subclass. At some relevant point one can call:\n\n    self.tcm_dump(class_to_track[, file])\n\n`class_to_track` needs a `tcm_get_state` method to return the\nsalient information, such as this from cs.resources.MultiOpenMixin:\n\n    def tcm_get_state(self):\n        return {\'opened\': self.opened, \'opens\': self._opens}\n\nSee cs.resources.MultiOpenMixin for example use.\n\n\n\n# Release Log\n\n*Release 20200318*:\nReplace obsolete O class with a new subclass of SimpleNamespace which issues a warning.\nNew singleton() generic factory function and SingletonMixin mixin class for making singleton classes.\n\n*Release 20190103*:\nNew mixin class TrackedClassMixin to track all instances of a particular class.\nDocumentation updates.\n\n*Release 20170904*:\nMinor cleanups.\n\n*Release 20160828*:\nUse "install_requires" instead of "requires" in DISTINFO.\nMinor tweaks.\n\n*Release 20150118*:\nmove long_description into cs/README-obj.rst\n\n*Release 20150110*:\ncleaned out some old junk, readied metadata for PyPI',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.obj'],
)
