"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehosePutRecordAction = exports.FirehoseRecordSeparator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * Record Separator to be used to separate records.
 */
var FirehoseRecordSeparator;
(function (FirehoseRecordSeparator) {
    /**
     * Separate by a new line
     */
    FirehoseRecordSeparator["NEWLINE"] = "\n";
    /**
     * Separate by a tab
     */
    FirehoseRecordSeparator["TAB"] = "\t";
    /**
     * Separate by a windows new line
     */
    FirehoseRecordSeparator["WINDOWS_NEWLINE"] = "\r\n";
    /**
     * Separate by a commma
     */
    FirehoseRecordSeparator["COMMA"] = ",";
})(FirehoseRecordSeparator = exports.FirehoseRecordSeparator || (exports.FirehoseRecordSeparator = {}));
/**
 * The action to put the record from an MQTT message to the Kinesis Data Firehose stream.
 */
class FirehosePutRecordAction {
    /**
     * @param stream The Kinesis Data Firehose stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_FirehosePutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.batchMode = props.batchMode;
        this.recordSeparator = props.recordSeparator;
        this.role = props.role;
    }
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        this.stream.grantPutRecords(role);
        return {
            configuration: {
                firehose: {
                    batchMode: this.batchMode,
                    deliveryStreamName: this.stream.deliveryStreamName,
                    roleArn: role.roleArn,
                    separator: this.recordSeparator,
                },
            },
        };
    }
}
exports.FirehosePutRecordAction = FirehosePutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
FirehosePutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.FirehosePutRecordAction", version: "1.156.1" };
//# sourceMappingURL=data:application/json;base64,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