#coverage:ignore
"""Tests for computing qubit vs toffoli for THC LCU"""
import numpy as np
from openfermion.resource_estimates.thc import qubit_vs_toffoli


def test_qubit_vs_toffoli_original_strategy():
    lam = 307.68
    dE = 0.001
    eps = dE / (10 * lam)
    n = 108
    chi = 10
    beta = 16
    M = 350

    # tof, qu array from costingTHCsteps.nb
    ref_tof = np.asarray([95,89,2852,10,18,10,54,402,1512,28,28,28,28,28,28,\
                          28,28,28,28,28,28,28,\
                          28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,\
                          28,28,28,28,28,28,28,\
                          28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,\
                          42,54,1,54,348,1512,\
                          1,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,\
                          28,28,28,28,28,28,\
                          28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,\
                          28,28,28,28,28,28,28,\
                          28,28,28,28,28,28,28,38,54,10,18,10,497,89,95,31,1])
    ref_qub = np.asarray([228,285,1182,251,241,241,241,1114,1119,1119,1103,\
                          1087,1071,1055,1039,\
                          1023,1007,991,975,959,943,927,911,895,879,863,847,\
                          831,815,799,783,767,\
                          751,735,719,703,687,671,655,639,623,607,591,575,559,\
                          543,527,511,495,479,\
                          463,447,431,415,399,383,367,351,335,319,303,287,271,\
                          262,241,241,241,1113,\
                          1119,1105,1119,1103,1087,1071,1055,1039,1023,1007,\
                          991,975,959,943,927,\
                          911,895,879,863,847,831,815,799,783,767,751,735,719,\
                          703,687,671,655,639,\
                          623,607,591,575,559,543,527,511,495,479,463,447,431,\
                          415,399,383,367,351,\
                          335,319,303,287,271,262,241,242,241,251,475,285,230,\
                          224,193])

    tgates, qubits, _, _ = qubit_vs_toffoli(lam, dE, eps, n, chi, beta, M, \
                                            algorithm='full', verbose=False)

    assert np.allclose(tgates.astype(int), ref_tof)
    assert np.allclose(qubits.astype(int), ref_qub)


def test_qubit_vs_toffoli_improved_strategy():
    lam = 307.68
    dE = 0.001
    eps = dE / (10 * lam)
    n = 108
    chi = 10
    beta = 16
    M = 350

    # tof, qu array from costingTHCsteps2.nb
    ref2_tof = np.asarray([95,89,4293,10,18,10,54,402,756,402,756,756,402,28,\
                           28,28,28,28,28,28,28,\
                           28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,\
                           28,28,42,54,1,54,348,\
                           756,348,756,1,756,348,28,28,28,28,28,28,28,28,28,\
                           28,28,28,28,28,28,28,\
                           28,28,28,28,28,28,28,28,28,28,28,38,54,10,18,10,497,\
                           89,95,50,1])
    ref2_qub = np.asarray([210,267,685,233,223,223,223,664,669,664,669,669,664,\
                           669,653,637,621,605,\
                           589,573,557,541,525,509,493,477,461,445,429,413,397,\
                           381,365,349,333,317,\
                           301,285,269,253,244,223,223,223,663,669,663,669,655,\
                           669,663,669,653,637,\
                           621,605,589,573,557,541,525,509,493,477,461,445,429,\
                           413,397,381,365,349,\
                           333,317,301,285,269,253,244,223,224,223,233,457,267,\
                           212,225,175])

    tgates, qubits, _, _ = qubit_vs_toffoli(lam, dE, eps, n, chi, beta, M, \
                                            algorithm='half', verbose=False)

    assert np.allclose(tgates.astype(int), ref2_tof)
    assert np.allclose(qubits.astype(int), ref2_qub)
