"""Common symbols for jubeat analyser files"""

NOTE_SYMBOLS = [
    "①",
    "②",
    "③",
    "④",
    "⑤",
    "⑥",
    "⑦",
    "⑧",
    "⑨",
    "⑩",
    "⑪",
    "⑫",
    "⑬",
    "⑭",
    "⑮",
    "⑯",
    "⑰",
    "⑱",
    "⑲",
    "⑳",
    "㉑",
    "㉒",
    "㉓",
    "㉔",
    "㉕",
    "㉖",
    "㉗",
    "㉘",
    "㉙",
    "㉚",
    "㉛",
    "㉜",
    "㉝",
    "㉞",
    "㉟",
    "㊱",
    "㊲",
    "㊳",
    "㊴",
    "㊵",
    "㊶",
    "㊷",
    "㊸",
    "㊹",
    "㊺",
    "㊻",
    "㊼",
    "㊽",
    "㊾",
    "㊿",
]

CIRCLE_FREE_SYMBOLS = [
    "１",  #  ⎫
    "２",  #  ⎪
    "３",  #  ⎪
    "４",  #  ⎪
    "５",  #  ⎬ FULLWIDTH
    "６",  #  ⎪
    "７",  #  ⎪
    "８",  #  ⎪
    "９",  #  ⎭
    "10",  #  ⎫
    "11",  #  ⎪
    "12",  #  ⎪
    "13",  #  ⎪
    "14",  #  ⎪
    "15",  #  ⎬ HALFWIDTH
    "16",  #  ⎪
    "17",  #  ⎪
    "18",  #  ⎪
    "19",  #  ⎪
    "20",  #  ⎭
]

LONG_ARROW_RIGHT = {
    ">",  # U+003E : GREATER-THAN SIGN
    "＞",  # U+FF1E : FULLWIDTH GREATER-THAN SIGN
}

LONG_ARROW_LEFT = {
    "<",  # U+003C : LESS-THAN SIGN
    "＜",  # U+FF1C : FULLWIDTH LESS-THAN SIGN
}

LONG_ARROW_DOWN = {
    "V",  # U+0056 : LATIN CAPITAL LETTER V
    "v",  # U+0076 : LATIN SMALL LETTER V
    "Ⅴ",  # U+2164 : ROMAN NUMERAL FIVE
    "ⅴ",  # U+2174 : SMALL ROMAN NUMERAL FIVE
    "∨",  # U+2228 : LOGICAL OR
    "Ｖ",  # U+FF36 : FULLWIDTH LATIN CAPITAL LETTER V
    "ｖ",  # U+FF56 : FULLWIDTH LATIN SMALL LETTER V
}

LONG_ARROW_UP = {
    "^",  # U+005E : CIRCUMFLEX ACCENT
    "∧",  # U+2227 : LOGICAL AND
}
