# follow FS-Net
import torch
import torch.nn as nn
import torch.nn.functional as F

from ...config import FLAGS
from . import gcn3d as gcn3d

# global feature num : the channels of feature from rgb and depth
# grid_num : the volume resolution


class PCL_Encoder(nn.Module):
    def __init__(self):
        super(PCL_Encoder, self).__init__()
        self.neighbor_num = FLAGS.gcn_n_num
        self.support_num = FLAGS.gcn_sup_num

        # 3D convolution for point cloud
        self.conv_0 = gcn3d.Conv_surface(kernel_num=128, support_num=self.support_num)
        self.conv_1 = gcn3d.Conv_layer(128, 128, support_num=self.support_num)
        self.pool_1 = gcn3d.Pool_layer(pooling_rate=4, neighbor_num=4)
        self.conv_2 = gcn3d.Conv_layer(128, 256, support_num=self.support_num)
        self.conv_3 = gcn3d.Conv_layer(256, 256, support_num=self.support_num)
        self.pool_2 = gcn3d.Pool_layer(pooling_rate=4, neighbor_num=4)
        self.conv_4 = gcn3d.Conv_layer(256, 512, support_num=self.support_num)

        self.bn1 = nn.BatchNorm1d(128)
        self.bn2 = nn.BatchNorm1d(256)
        self.bn3 = nn.BatchNorm1d(256)

        self.recon_num = 3
        self.face_recon_num = FLAGS.face_recon_c

    def forward(
        self,
        vertices: "tensor (bs, vetice_num, 3)",
        cat_id: "tensor (bs, 1)",
    ):
        """
        Return: (bs, vertice_num, class_num)
        """
        #  concate feature
        bs, vertice_num, _ = vertices.size()
        # cat_id to one-hot
        if cat_id.shape[0] == 1:
            obj_idh = cat_id.view(-1, 1).repeat(cat_id.shape[0], 1)
        else:
            obj_idh = cat_id.view(-1, 1)

        one_hot = (
            torch.zeros(bs, FLAGS.obj_c)
            .to(cat_id.device)
            .scatter_(1, obj_idh.long(), 1)
        )
        # bs x verticenum x 6

        neighbor_index = gcn3d.get_neighbor_index(vertices, self.neighbor_num)
        # ss = time.time()
        fm_0 = F.relu(self.conv_0(neighbor_index, vertices), inplace=True)

        fm_1 = F.relu(
            self.bn1(
                self.conv_1(neighbor_index, vertices, fm_0).transpose(1, 2)
            ).transpose(1, 2),
            inplace=True,
        )
        v_pool_1, fm_pool_1 = self.pool_1(vertices, fm_1)
        # neighbor_index = gcn3d.get_neighbor_index(v_pool_1, self.neighbor_num)
        neighbor_index = gcn3d.get_neighbor_index(
            v_pool_1, min(self.neighbor_num, v_pool_1.shape[1] // 8)
        )
        fm_2 = F.relu(
            self.bn2(
                self.conv_2(neighbor_index, v_pool_1, fm_pool_1).transpose(1, 2)
            ).transpose(1, 2),
            inplace=True,
        )
        fm_3 = F.relu(
            self.bn3(
                self.conv_3(neighbor_index, v_pool_1, fm_2).transpose(1, 2)
            ).transpose(1, 2),
            inplace=True,
        )
        v_pool_2, fm_pool_2 = self.pool_2(v_pool_1, fm_3)
        # neighbor_index = gcn3d.get_neighbor_index(v_pool_2, self.neighbor_num)
        neighbor_index = gcn3d.get_neighbor_index(
            v_pool_2, min(self.neighbor_num, v_pool_2.shape[1] // 8)
        )
        fm_4 = self.conv_4(neighbor_index, v_pool_2, fm_pool_2)
        f_global = fm_4.max(1)[0]  # (bs, f)

        nearest_pool_1 = gcn3d.get_nearest_index(vertices, v_pool_1)
        nearest_pool_2 = gcn3d.get_nearest_index(vertices, v_pool_2)
        fm_2 = gcn3d.indexing_neighbor(fm_2, nearest_pool_1).squeeze(2)
        fm_3 = gcn3d.indexing_neighbor(fm_3, nearest_pool_1).squeeze(2)
        fm_4 = gcn3d.indexing_neighbor(fm_4, nearest_pool_2).squeeze(2)
        one_hot = one_hot.unsqueeze(1).repeat(
            1, vertice_num, 1
        )  # (bs, vertice_num, cat_one_hot)

        feat = torch.cat([fm_0, fm_1, fm_2, fm_3, fm_4, one_hot], dim=2)
        return feat, f_global


def main(argv):
    classifier_seg3D = PCL_Encoder()

    points = torch.rand(2, 1000, 3)
    import numpy as np

    obj_idh = torch.ones((2, 1))
    obj_idh[1, 0] = 5
    """
    if obj_idh.shape[0] == 1:
        obj_idh = obj_idh.view(-1, 1).repeat(points.shape[0], 1)
    else:
        obj_idh = obj_idh.view(-1, 1)

    one_hot = torch.zeros(points.shape[0], 6).scatter_(1, obj_idh.cpu().long(), 1)
    """
    feat = classifier_seg3D(points, obj_idh)
    t = 1


if __name__ == "__main__":
    print(1)
    from config.config import *

    app.run(main)
