"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancePolicy = exports.VersionsLists = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 *
 */
var VersionsLists;
(function (VersionsLists) {
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V1"] = "v1";
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V2"] = "v2";
})(VersionsLists = exports.VersionsLists || (exports.VersionsLists = {}));
const awsLoadBalancerControllerPolicyV1 = {
    actions: [
        'acm:DescribeCertificate',
        'acm:ListCertificates',
        'acm:GetCertificate',
        'ec2:AuthorizeSecurityGroupIngress',
        'ec2:CreateSecurityGroup',
        'ec2:CreateTags',
        'ec2:DeleteTags',
        'ec2:DeleteSecurityGroup',
        'ec2:DescribeAccountAttributes',
        'ec2:DescribeAddresses',
        'ec2:DescribeInstances',
        'ec2:DescribeInstanceStatus',
        'ec2:DescribeInternetGateways',
        'ec2:DescribeNetworkInterfaces',
        'ec2:DescribeSecurityGroups',
        'ec2:DescribeSubnets',
        'ec2:DescribeTags',
        'ec2:DescribeVpcs',
        'ec2:ModifyInstanceAttribute',
        'ec2:ModifyNetworkInterfaceAttribute',
        'ec2:RevokeSecurityGroupIngress',
        'elasticloadbalancing:AddListenerCertificates',
        'elasticloadbalancing:AddTags',
        'elasticloadbalancing:CreateListener',
        'elasticloadbalancing:CreateLoadBalancer',
        'elasticloadbalancing:CreateRule',
        'elasticloadbalancing:CreateTargetGroup',
        'elasticloadbalancing:DeleteListener',
        'elasticloadbalancing:DeleteLoadBalancer',
        'elasticloadbalancing:DeleteRule',
        'elasticloadbalancing:DeleteTargetGroup',
        'elasticloadbalancing:DeregisterTargets',
        'elasticloadbalancing:DescribeListenerCertificates',
        'elasticloadbalancing:DescribeListeners',
        'elasticloadbalancing:DescribeLoadBalancers',
        'elasticloadbalancing:DescribeLoadBalancerAttributes',
        'elasticloadbalancing:DescribeRules',
        'elasticloadbalancing:DescribeSSLPolicies',
        'elasticloadbalancing:DescribeTags',
        'elasticloadbalancing:DescribeTargetGroups',
        'elasticloadbalancing:DescribeTargetGroupAttributes',
        'elasticloadbalancing:DescribeTargetHealth',
        'elasticloadbalancing:ModifyListener',
        'elasticloadbalancing:ModifyLoadBalancerAttributes',
        'elasticloadbalancing:ModifyRule',
        'elasticloadbalancing:ModifyTargetGroup',
        'elasticloadbalancing:ModifyTargetGroupAttributes',
        'elasticloadbalancing:RegisterTargets',
        'elasticloadbalancing:RemoveListenerCertificates',
        'elasticloadbalancing:RemoveTags',
        'elasticloadbalancing:SetIpAddressType',
        'elasticloadbalancing:SetSecurityGroups',
        'elasticloadbalancing:SetSubnets',
        'elasticloadbalancing:SetWebAcl',
        'iam:CreateServiceLinkedRole',
        'iam:GetServerCertificate',
        'iam:ListServerCertificates',
        'cognito-idp:DescribeUserPoolClient',
        'waf-regional:GetWebACLForResource',
        'waf-regional:GetWebACL',
        'waf-regional:AssociateWebACL',
        'waf-regional:DisassociateWebACL',
        'tag:GetResources',
        'tag:TagResources',
        'waf:GetWebACL',
        'wafv2:GetWebACL',
        'wafv2:GetWebACLForResource',
        'wafv2:AssociateWebACL',
        'wafv2:DisassociateWebACL',
        'shield:DescribeProtection',
        'shield:GetSubscriptionState',
        'shield:DeleteProtection',
        'shield:CreateProtection',
        'shield:DescribeSubscription',
    ],
    resources: ['*'],
};
const awsLoadBalancerControllerPolicyV2 = [
    [
        {
            Effect: 'Allow',
            Action: [
                'iam:CreateServiceLinkedRole',
                'ec2:DescribeAccountAttributes',
                'ec2:DescribeAddresses',
                'ec2:DescribeAvailabilityZones',
                'ec2:DescribeInternetGateways',
                'ec2:DescribeVpcs',
                'ec2:DescribeSubnets',
                'ec2:DescribeSecurityGroups',
                'ec2:DescribeInstances',
                'ec2:DescribeNetworkInterfaces',
                'ec2:DescribeTags',
                'ec2:GetCoipPoolUsage',
                'ec2:DescribeCoipPools',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeLoadBalancerAttributes',
                'elasticloadbalancing:DescribeListeners',
                'elasticloadbalancing:DescribeListenerCertificates',
                'elasticloadbalancing:DescribeSSLPolicies',
                'elasticloadbalancing:DescribeRules',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetGroupAttributes',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:DescribeTags',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'cognito-idp:DescribeUserPoolClient',
                'acm:ListCertificates',
                'acm:DescribeCertificate',
                'iam:ListServerCertificates',
                'iam:GetServerCertificate',
                'waf-regional:GetWebACL',
                'waf-regional:GetWebACLForResource',
                'waf-regional:AssociateWebACL',
                'waf-regional:DisassociateWebACL',
                'wafv2:GetWebACL',
                'wafv2:GetWebACLForResource',
                'wafv2:AssociateWebACL',
                'wafv2:DisassociateWebACL',
                'shield:GetSubscriptionState',
                'shield:DescribeProtection',
                'shield:CreateProtection',
                'shield:DeleteProtection',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:AuthorizeSecurityGroupIngress',
                'ec2:RevokeSecurityGroupIngress',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:CreateSecurityGroup',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:CreateTags',
            ],
            Resource: 'arn:aws:ec2:*:*:security-group/*',
            Condition: {
                StringEquals: {
                    'ec2:CreateAction': 'CreateSecurityGroup',
                },
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:CreateTags',
                'ec2:DeleteTags',
            ],
            Resource: 'arn:aws:ec2:*:*:security-group/*',
            Condition: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'ec2:AuthorizeSecurityGroupIngress',
                'ec2:RevokeSecurityGroupIngress',
                'ec2:DeleteSecurityGroup',
            ],
            Resource: '*',
            Condition: {
                Null: {
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:CreateLoadBalancer',
                'elasticloadbalancing:CreateTargetGroup',
            ],
            Resource: '*',
            Condition: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:CreateListener',
                'elasticloadbalancing:DeleteListener',
                'elasticloadbalancing:CreateRule',
                'elasticloadbalancing:DeleteRule',
            ],
            Resource: '*',
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:AddTags',
                'elasticloadbalancing:RemoveTags',
            ],
            Resource: [
                'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
                'arn:aws:elasticloadbalancing:*:*:loadbalancer/net/*/*',
                'arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*',
            ],
            Condition: {
                Null: {
                    'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:AddTags',
                'elasticloadbalancing:RemoveTags',
            ],
            Resource: [
                'arn:aws:elasticloadbalancing:*:*:listener/net/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener/app/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener-rule/net/*/*/*',
                'arn:aws:elasticloadbalancing:*:*:listener-rule/app/*/*/*',
            ],
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:ModifyLoadBalancerAttributes',
                'elasticloadbalancing:SetIpAddressType',
                'elasticloadbalancing:SetSecurityGroups',
                'elasticloadbalancing:SetSubnets',
                'elasticloadbalancing:DeleteLoadBalancer',
                'elasticloadbalancing:ModifyTargetGroup',
                'elasticloadbalancing:ModifyTargetGroupAttributes',
                'elasticloadbalancing:DeleteTargetGroup',
            ],
            Resource: '*',
            Condition: {
                Null: {
                    'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
                },
            },
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:RegisterTargets',
                'elasticloadbalancing:DeregisterTargets',
            ],
            Resource: 'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
        },
        {
            Effect: 'Allow',
            Action: [
                'elasticloadbalancing:SetWebAcl',
                'elasticloadbalancing:ModifyListener',
                'elasticloadbalancing:AddListenerCertificates',
                'elasticloadbalancing:RemoveListenerCertificates',
                'elasticloadbalancing:ModifyRule',
            ],
            Resource: '*',
        },
    ],
];
/**
 * awsLoadBalancePolicy class ,help you add policy to your Iam Role for service account.
 */
class AwsLoadBalancePolicy {
    /**
     *
     */
    static addPolicy(version, role) {
        if (version == 'v1') {
            role.addToPolicy(new iam.PolicyStatement(awsLoadBalancerControllerPolicyV1));
            return role;
        }
        if (version == 'v2') {
            awsLoadBalancerControllerPolicyV2.forEach(element => {
                role.addToPolicy(iam.PolicyStatement.fromJson(element));
            });
            return role;
        }
    }
}
exports.AwsLoadBalancePolicy = AwsLoadBalancePolicy;
;
//# sourceMappingURL=data:application/json;base64,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