"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNoneAuthorizer = exports.HttpAuthorizer = exports.AuthorizerPayloadVersion = exports.HttpAuthorizerType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * (experimental) Supported Authorizer types.
 *
 * @experimental
 */
var HttpAuthorizerType;
(function (HttpAuthorizerType) {
    HttpAuthorizerType["JWT"] = "JWT";
    HttpAuthorizerType["LAMBDA"] = "REQUEST";
})(HttpAuthorizerType = exports.HttpAuthorizerType || (exports.HttpAuthorizerType = {}));
/**
 * (experimental) Payload format version for lambda authorizers.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html
 * @experimental
 */
var AuthorizerPayloadVersion;
(function (AuthorizerPayloadVersion) {
    AuthorizerPayloadVersion["VERSION_1_0"] = "1.0";
    AuthorizerPayloadVersion["VERSION_2_0"] = "2.0";
})(AuthorizerPayloadVersion = exports.AuthorizerPayloadVersion || (exports.AuthorizerPayloadVersion = {}));
/**
 * (experimental) An authorizer for Http Apis.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Authorizer
 */
class HttpAuthorizer extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _c, _d;
        super(scope, id);
        let authorizerPayloadFormatVersion = props.payloadFormatVersion;
        if (props.type === HttpAuthorizerType.JWT && (!props.jwtAudience || props.jwtAudience.length === 0 || !props.jwtIssuer)) {
            throw new Error('jwtAudience and jwtIssuer are mandatory for JWT authorizers');
        }
        if (props.type === HttpAuthorizerType.LAMBDA && !props.authorizerUri) {
            throw new Error('authorizerUri is mandatory for Lambda authorizers');
        }
        /**
         * This check is required because Cloudformation will fail stack creation is this property
         * is set for the JWT authorizer. AuthorizerPayloadFormatVersion can only be set for REQUEST authorizer
         */
        if (props.type === HttpAuthorizerType.LAMBDA && typeof authorizerPayloadFormatVersion === 'undefined') {
            authorizerPayloadFormatVersion = AuthorizerPayloadVersion.VERSION_2_0;
        }
        const resource = new aws_apigatewayv2_1.CfnAuthorizer(this, 'Resource', {
            name: (_c = props.authorizerName) !== null && _c !== void 0 ? _c : id,
            apiId: props.httpApi.apiId,
            authorizerType: props.type,
            identitySource: props.identitySource,
            jwtConfiguration: undefinedIfNoKeys({
                audience: props.jwtAudience,
                issuer: props.jwtIssuer,
            }),
            enableSimpleResponses: props.enableSimpleResponses,
            authorizerPayloadFormatVersion,
            authorizerUri: props.authorizerUri,
            authorizerResultTtlInSeconds: (_d = props.resultsCacheTtl) === null || _d === void 0 ? void 0 : _d.toSeconds(),
        });
        this.authorizerId = resource.ref;
    }
    /**
     * (experimental) Import an existing HTTP Authorizer into this CDK app.
     *
     * @experimental
     */
    static fromHttpAuthorizerAttributes(scope, id, attrs) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.authorizerId = attrs.authorizerId;
                this.authorizerType = attrs.authorizerType;
            }
            bind() {
                return {
                    authorizerId: attrs.authorizerId,
                    authorizationType: attrs.authorizerType,
                };
            }
        }
        return new Import(scope, id);
    }
}
exports.HttpAuthorizer = HttpAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpAuthorizer", version: "2.0.0-alpha.1" };
function undefinedIfNoKeys(obj) {
    const allUndefined = Object.values(obj).every(val => val === undefined);
    return allUndefined ? undefined : obj;
}
/**
 * (experimental) Explicitly configure no authorizers on specific HTTP API routes.
 *
 * @experimental
 */
class HttpNoneAuthorizer {
    /**
     * (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(_) {
        return {
            authorizationType: 'NONE',
        };
    }
}
exports.HttpNoneAuthorizer = HttpNoneAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
HttpNoneAuthorizer[_b] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpNoneAuthorizer", version: "2.0.0-alpha.1" };
//# sourceMappingURL=data:application/json;base64,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