import * as cdk from '@aws-cdk/core';
/**
 * Schema for Module Fragment of type logzio::autoDeploymentLogzio::CloudWatch::MODULE.
 *
 * @schema CfnModuleProps
 */
export interface CfnModuleProps {
    /**
     * @schema CfnModuleProps#Parameters
     */
    readonly parameters?: CfnModulePropsParameters;
    /**
     * @schema CfnModuleProps#Resources
     */
    readonly resources?: CfnModulePropsResources;
}
/**
 * Converts an object of type 'CfnModuleProps' to JSON representation.
 */
export declare function toJson_CfnModuleProps(obj: CfnModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsParameters
 */
export interface CfnModulePropsParameters {
    /**
     * The Logz.io listener URL fot your region.
     *
     * @schema CfnModulePropsParameters#LogzioListenerUrl
     */
    readonly logzioListenerUrl?: CfnModulePropsParametersLogzioListenerUrl;
    /**
     * Logz.io account token.
     *
     * @schema CfnModulePropsParameters#LogzioToken
     */
    readonly logzioToken?: CfnModulePropsParametersLogzioToken;
    /**
     * The log type you'll use with this Lambda.
     *
     * Please note that you should create a new Lambda for each log type you use. This can be a built-in log type, or your custom log type
     *
     * @schema CfnModulePropsParameters#LogzioType
     */
    readonly logzioType?: CfnModulePropsParametersLogzioType;
    /**
     * JSON or text.
     *
     * If json, the lambda function will attempt to parse the message field as JSON and populate the event data with the parsed fields.
     *
     * @schema CfnModulePropsParameters#LogzioFormat
     */
    readonly logzioFormat?: CfnModulePropsParametersLogzioFormat;
    /**
     * If true, the Lambda will send compressed logs.
     *
     * If false, the Lambda will send uncompressed logs.
     *
     * @schema CfnModulePropsParameters#LogzioCompress
     */
    readonly logzioCompress?: CfnModulePropsParametersLogzioCompress;
    /**
     * By default, we do not send logs of type START, END, REPORT.
     *
     * Choose true to send all log types.
     *
     * @schema CfnModulePropsParameters#LogzioSendAll
     */
    readonly logzioSendAll?: CfnModulePropsParametersLogzioSendAll;
    /**
     * Enriches the CloudWatch events with custom properties at ship time.
     *
     * The format is `key1=value1;key2=value2`. By default is empty.
     *
     * @schema CfnModulePropsParameters#LogzioEnrich
     */
    readonly logzioEnrich?: CfnModulePropsParametersLogzioEnrich;
    /**
     * CloudWatch Log Group name from where you want to send logs.
     *
     * @schema CfnModulePropsParameters#LogGroup
     */
    readonly logGroup?: CfnModulePropsParametersLogGroup;
}
/**
 * Converts an object of type 'CfnModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnModulePropsParameters(obj: CfnModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResources
 */
export interface CfnModulePropsResources {
    /**
     * @schema CfnModulePropsResources#LambdaPermission
     */
    readonly lambdaPermission?: CfnModulePropsResourcesLambdaPermission;
    /**
     * @schema CfnModulePropsResources#LogzioSubscriptionFilter
     */
    readonly logzioSubscriptionFilter?: CfnModulePropsResourcesLogzioSubscriptionFilter;
    /**
     * @schema CfnModulePropsResources#lambdaIamRole
     */
    readonly lambdaIamRole?: CfnModulePropsResourcesLambdaIamRole;
    /**
     * @schema CfnModulePropsResources#LogzioCloudwatchLogsLambda
     */
    readonly logzioCloudwatchLogsLambda?: CfnModulePropsResourcesLogzioCloudwatchLogsLambda;
}
/**
 * Converts an object of type 'CfnModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnModulePropsResources(obj: CfnModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The Logz.io listener URL fot your region.
 *
 * @schema CfnModulePropsParametersLogzioListenerUrl
 */
export interface CfnModulePropsParametersLogzioListenerUrl {
    /**
     * @schema CfnModulePropsParametersLogzioListenerUrl#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioListenerUrl#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioListenerUrl' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioListenerUrl(obj: CfnModulePropsParametersLogzioListenerUrl | undefined): Record<string, any> | undefined;
/**
 * Logz.io account token.
 *
 * @schema CfnModulePropsParametersLogzioToken
 */
export interface CfnModulePropsParametersLogzioToken {
    /**
     * @schema CfnModulePropsParametersLogzioToken#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioToken#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioToken' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioToken(obj: CfnModulePropsParametersLogzioToken | undefined): Record<string, any> | undefined;
/**
 * The log type you'll use with this Lambda.
 *
 * Please note that you should create a new Lambda for each log type you use. This can be a built-in log type, or your custom log type
 *
 * @schema CfnModulePropsParametersLogzioType
 */
export interface CfnModulePropsParametersLogzioType {
    /**
     * @schema CfnModulePropsParametersLogzioType#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioType#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioType' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioType(obj: CfnModulePropsParametersLogzioType | undefined): Record<string, any> | undefined;
/**
 * JSON or text.
 *
 * If json, the lambda function will attempt to parse the message field as JSON and populate the event data with the parsed fields.
 *
 * @schema CfnModulePropsParametersLogzioFormat
 */
export interface CfnModulePropsParametersLogzioFormat {
    /**
     * @schema CfnModulePropsParametersLogzioFormat#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioFormat#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioFormat' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioFormat(obj: CfnModulePropsParametersLogzioFormat | undefined): Record<string, any> | undefined;
/**
 * If true, the Lambda will send compressed logs.
 *
 * If false, the Lambda will send uncompressed logs.
 *
 * @schema CfnModulePropsParametersLogzioCompress
 */
export interface CfnModulePropsParametersLogzioCompress {
    /**
     * @schema CfnModulePropsParametersLogzioCompress#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioCompress#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioCompress' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioCompress(obj: CfnModulePropsParametersLogzioCompress | undefined): Record<string, any> | undefined;
/**
 * By default, we do not send logs of type START, END, REPORT.
 *
 * Choose true to send all log types.
 *
 * @schema CfnModulePropsParametersLogzioSendAll
 */
export interface CfnModulePropsParametersLogzioSendAll {
    /**
     * @schema CfnModulePropsParametersLogzioSendAll#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioSendAll#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioSendAll' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioSendAll(obj: CfnModulePropsParametersLogzioSendAll | undefined): Record<string, any> | undefined;
/**
 * Enriches the CloudWatch events with custom properties at ship time.
 *
 * The format is `key1=value1;key2=value2`. By default is empty.
 *
 * @schema CfnModulePropsParametersLogzioEnrich
 */
export interface CfnModulePropsParametersLogzioEnrich {
    /**
     * @schema CfnModulePropsParametersLogzioEnrich#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogzioEnrich#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogzioEnrich' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogzioEnrich(obj: CfnModulePropsParametersLogzioEnrich | undefined): Record<string, any> | undefined;
/**
 * CloudWatch Log Group name from where you want to send logs.
 *
 * @schema CfnModulePropsParametersLogGroup
 */
export interface CfnModulePropsParametersLogGroup {
    /**
     * @schema CfnModulePropsParametersLogGroup#Type
     */
    readonly type: string;
    /**
     * @schema CfnModulePropsParametersLogGroup#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnModulePropsParametersLogGroup' to JSON representation.
 */
export declare function toJson_CfnModulePropsParametersLogGroup(obj: CfnModulePropsParametersLogGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLambdaPermission
 */
export interface CfnModulePropsResourcesLambdaPermission {
    /**
     * @schema CfnModulePropsResourcesLambdaPermission#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLambdaPermission#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLambdaPermission' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLambdaPermission(obj: CfnModulePropsResourcesLambdaPermission | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLogzioSubscriptionFilter
 */
export interface CfnModulePropsResourcesLogzioSubscriptionFilter {
    /**
     * @schema CfnModulePropsResourcesLogzioSubscriptionFilter#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLogzioSubscriptionFilter#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLogzioSubscriptionFilter' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLogzioSubscriptionFilter(obj: CfnModulePropsResourcesLogzioSubscriptionFilter | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLambdaIamRole
 */
export interface CfnModulePropsResourcesLambdaIamRole {
    /**
     * @schema CfnModulePropsResourcesLambdaIamRole#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLambdaIamRole#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLambdaIamRole' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLambdaIamRole(obj: CfnModulePropsResourcesLambdaIamRole | undefined): Record<string, any> | undefined;
/**
 * @schema CfnModulePropsResourcesLogzioCloudwatchLogsLambda
 */
export interface CfnModulePropsResourcesLogzioCloudwatchLogsLambda {
    /**
     * @schema CfnModulePropsResourcesLogzioCloudwatchLogsLambda#Type
     */
    readonly type?: string;
    /**
     * @schema CfnModulePropsResourcesLogzioCloudwatchLogsLambda#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnModulePropsResourcesLogzioCloudwatchLogsLambda' to JSON representation.
 */
export declare function toJson_CfnModulePropsResourcesLogzioCloudwatchLogsLambda(obj: CfnModulePropsResourcesLogzioCloudwatchLogsLambda | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `logzio::autoDeploymentLogzio::CloudWatch::MODULE`.
 *
 * @external
 * @cloudformationResource logzio::autoDeploymentLogzio::CloudWatch::MODULE
 * @link http://unknown-url
 */
export declare class CfnModule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "logzio::autoDeploymentLogzio::CloudWatch::MODULE";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnModuleProps;
    /**
     * Create a new `logzio::autoDeploymentLogzio::CloudWatch::MODULE`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModuleProps);
}
