import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/r/order#id Order#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/r/order#last_updated Order#last_updated}
    */
    readonly lastUpdated?: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/r/order#items Order#items}
    */
    readonly items: OrderItems[] | cdktf.IResolvable;
}
export interface OrderItemsCoffee {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/r/order#id Order#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: number;
}
export declare function orderItemsCoffeeToTerraform(struct?: OrderItemsCoffeeOutputReference | OrderItemsCoffee): any;
export declare class OrderItemsCoffeeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrderItemsCoffee | undefined;
    set internalValue(value: OrderItemsCoffee | undefined);
    get description(): string;
    private _id?;
    get id(): number;
    set id(value: number);
    get idInput(): number | undefined;
    get image(): string;
    get name(): string;
    get price(): number;
    get teaser(): string;
}
export interface OrderItems {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/r/order#quantity Order#quantity}
    */
    readonly quantity: number;
    /**
    * coffee block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/hashicups/r/order#coffee Order#coffee}
    */
    readonly coffee: OrderItemsCoffee;
}
export declare function orderItemsToTerraform(struct?: OrderItems | cdktf.IResolvable): any;
export declare class OrderItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrderItems | cdktf.IResolvable | undefined;
    set internalValue(value: OrderItems | cdktf.IResolvable | undefined);
    private _quantity?;
    get quantity(): number;
    set quantity(value: number);
    get quantityInput(): number | undefined;
    private _coffee;
    get coffee(): OrderItemsCoffeeOutputReference;
    putCoffee(value: OrderItemsCoffee): void;
    get coffeeInput(): OrderItemsCoffee | undefined;
}
export declare class OrderItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrderItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrderItemsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/hashicups/r/order hashicups_order}
*/
export declare class Order extends cdktf.TerraformResource {
    static readonly tfResourceType = "hashicups_order";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/hashicups/r/order hashicups_order} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrderConfig
    */
    constructor(scope: Construct, id: string, config: OrderConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastUpdated?;
    get lastUpdated(): string;
    set lastUpdated(value: string);
    resetLastUpdated(): void;
    get lastUpdatedInput(): string | undefined;
    private _items;
    get items(): OrderItemsList;
    putItems(value: OrderItems[] | cdktf.IResolvable): void;
    get itemsInput(): cdktf.IResolvable | OrderItems[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
