from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

from compas_3gs.datastructures import Network3gs

from compas_3gs.diagrams import Cell


__author__     = 'Juney Lee'
__copyright__  = 'Copyright 2019, BLOCK Research Group - ETH Zurich'
__license__    = 'MIT License'
__email__      = 'juney.lee@arch.ethz.ch'


__all__ = ['CellNetwork']


class CellNetwork(Network3gs):
    """A disjointed, non-polyhedral form and force diagram.

    """

    def __init__(self):
        super(CellNetwork, self).__init__()

        a  = {'gfp'  : Cell()}
        va = {'x_fix': False,
              'y_fix': False,
              'z_fix': False,
              'cell' : Cell()}
        ea = {'target_vector': None,
              'target_length': None}

        self.cells = {}

        self.attributes.update(a)
        self.default_vertex_attributes.update(va)
        self.default_edge_attributes.update(ea)


# ******************************************************************************
# ******************************************************************************
# ******************************************************************************
#
#   Main
#
# ******************************************************************************
# ******************************************************************************
# ******************************************************************************


if __name__ == '__main__':
    pass
