# compas_3gs

``compas_3gs`` is a 3D graphic statics add-on package for the **COMPAS** framework.


## Installation

First, create an environment with a specific versino of Python.

```bash
$ conda create -n 3gs python=3.7
```

Activate the new environment.

```bash
$ conda activate 3gs
```

Released versions of ``compas_3gs`` can be installed with *pip*.

```bash
$ pip install compas-3gs
```

Then, install compas_3gs for Rhino.

```bash
$ python -m compas_rhino.install -p compas_3gs
```

## First Steps

* [Theoretical background](https://compas-dev.github.io/compas_3gs/theoretical_background.html)
* [Examples](https://compas-dev.github.io/compas_3gs/examples.html)
* [API reference](https://compas-dev.github.io/compas_3gs/api_reference.html)


## Questions and discussions

The ``compas_3gs`` library has a forum: https://forum.compas-framework.org/c/compas-3gs for questions and discussions.


## Issue tracker

If you find a bug, please help us solve it by [filing a report](https://github.com/BlockResearchGroup/compas_3gs/issues).


## Contributing

If you would like to contribute, check out the [contribution guidelines](https://blockresearchgroup.github.io/compas_3gs/contribution.html).
All contributions and relevant publications will be fully credited under [Publications](https://compas-dev.github.io/compas_3gs/Publications.html).


## License

The ``compas_3gs`` add-on package for **COMPAS** is [released under the MIT license](https://compas-dev.github.io/compas_3gs/license.html).


## Contact

For any additional suggestions or feedback, please conact the main contributors of ``compas_3gs``, Juney Lee (juney.lee@arch.ethz.ch) and Tom Van Mele (van.mele@arch.ethz.ch).
