/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
export declare const PATH_METADATA_ENABLE_CONTEXT = "aws:cdk:enable-path-metadata";
/**
 * Disable the collection and reporting of version information.
 */
export declare const DISABLE_VERSION_REPORTING = "aws:cdk:disable-version-reporting";
/**
 * If this is set, asset staging is disabled. This means that assets will not be copied to
 * the output directory and will be referenced with absolute source paths.
 */
export declare const DISABLE_ASSET_STAGING_CONTEXT = "aws:cdk:disable-asset-staging";
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
export declare const DISABLE_METADATA_STACK_TRACE = "aws:cdk:disable-stack-trace";
