"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateRetryPolicy = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const DEFAULT_TIMEOUT = core_1.Duration.minutes(30);
const DEFAULT_INTERVAL = core_1.Duration.seconds(5);
function calculateRetryPolicy(props = {}) {
    const totalTimeout = props.totalTimeout || DEFAULT_TIMEOUT;
    const interval = props.queryInterval || DEFAULT_INTERVAL;
    const maxAttempts = totalTimeout.toSeconds() / interval.toSeconds();
    if (Math.round(maxAttempts) !== maxAttempts) {
        throw new Error(`Cannot determine retry count since totalTimeout=${totalTimeout.toSeconds()}s is not integrally dividable by queryInterval=${interval.toSeconds()}s`);
    }
    return {
        maxAttempts,
        interval,
        backoffRate: 1,
    };
}
exports.calculateRetryPolicy = calculateRetryPolicy;
//# sourceMappingURL=data:application/json;base64,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