import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
import { IStackSynthesizer } from './types';
/**
 * Deployment environment for a nested stack
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
export declare class NestedStackSynthesizer implements IStackSynthesizer {
    private readonly parentDeployment;
    constructor(parentDeployment: IStackSynthesizer);
    bind(_stack: Stack): void;
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    synthesizeStackArtifacts(_session: ISynthesisSession): void;
}
