"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RotationSchedule = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * A rotation schedule.
 */
class RotationSchedule extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: props.rotationLambda.functionArn,
            rotationRules: {
                automaticallyAfterDays: props.automaticallyAfter && props.automaticallyAfter.toDays() || 30,
            },
        });
    }
}
exports.RotationSchedule = RotationSchedule;
//# sourceMappingURL=data:application/json;base64,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