"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiEventSource = void 0;
const apigw = require("../../aws-apigateway"); // Automatically re-written from '@aws-cdk/aws-apigateway'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        const id = `${target.node.uniqueId}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
//# sourceMappingURL=data:application/json;base64,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