"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * A principal to allow access to a key if it's being used through another AWS service
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
//# sourceMappingURL=data:application/json;base64,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