"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.arrayDiff = void 0;
function arrayDiff(oldValues, newValues) {
    const deletes = new Set(oldValues);
    const adds = new Set();
    for (const v of new Set(newValues)) {
        if (deletes.has(v)) {
            deletes.delete(v);
        }
        else {
            adds.add(v);
        }
    }
    return {
        adds: Array.from(adds),
        deletes: Array.from(deletes),
    };
}
exports.arrayDiff = arrayDiff;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGlmZi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRpZmYudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsU0FBZ0IsU0FBUyxDQUFDLFNBQW1CLEVBQUUsU0FBbUI7SUFDOUQsTUFBTSxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDbkMsTUFBTSxJQUFJLEdBQUcsSUFBSSxHQUFHLEVBQVUsQ0FBQztJQUMvQixLQUFLLE1BQU0sQ0FBQyxJQUFJLElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxFQUFFO1FBQ2hDLElBQUksT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUNoQixPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3JCO2FBQ0k7WUFDRCxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ2Y7S0FDSjtJQUNELE9BQU87UUFDSCxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7UUFDdEIsT0FBTyxFQUFFLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO0tBQy9CLENBQUM7QUFDTixDQUFDO0FBZkQsOEJBZUMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gYXJyYXlEaWZmKG9sZFZhbHVlczogc3RyaW5nW10sIG5ld1ZhbHVlczogc3RyaW5nW10pIHtcbiAgICBjb25zdCBkZWxldGVzID0gbmV3IFNldChvbGRWYWx1ZXMpO1xuICAgIGNvbnN0IGFkZHMgPSBuZXcgU2V0PHN0cmluZz4oKTtcbiAgICBmb3IgKGNvbnN0IHYgb2YgbmV3IFNldChuZXdWYWx1ZXMpKSB7XG4gICAgICAgIGlmIChkZWxldGVzLmhhcyh2KSkge1xuICAgICAgICAgICAgZGVsZXRlcy5kZWxldGUodik7XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICBhZGRzLmFkZCh2KTtcbiAgICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgICBhZGRzOiBBcnJheS5mcm9tKGFkZHMpLFxuICAgICAgICBkZWxldGVzOiBBcnJheS5mcm9tKGRlbGV0ZXMpLFxuICAgIH07XG59XG4iXX0=