import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Elasticsearch::Domain`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 */
export interface CfnDomainProps {
    /**
     * `AWS::Elasticsearch::Domain.AccessPolicies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies
     */
    readonly accessPolicies?: any | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
     */
    readonly advancedOptions?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedSecurityOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions
     */
    readonly advancedSecurityOptions?: CfnDomain.AdvancedSecurityOptionsInputProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.CognitoOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
     */
    readonly cognitoOptions?: CfnDomain.CognitoOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.DomainEndpointOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions
     */
    readonly domainEndpointOptions?: CfnDomain.DomainEndpointOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname
     */
    readonly domainName?: string;
    /**
     * `AWS::Elasticsearch::Domain.EBSOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
     */
    readonly ebsOptions?: CfnDomain.EBSOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
     */
    readonly elasticsearchClusterConfig?: CfnDomain.ElasticsearchClusterConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion
     */
    readonly elasticsearchVersion?: string;
    /**
     * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
     */
    readonly encryptionAtRestOptions?: CfnDomain.EncryptionAtRestOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.LogPublishingOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
     */
    readonly logPublishingOptions?: {
        [key: string]: (CfnDomain.LogPublishingOptionProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
     */
    readonly nodeToNodeEncryptionOptions?: CfnDomain.NodeToNodeEncryptionOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.SnapshotOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
     */
    readonly snapshotOptions?: CfnDomain.SnapshotOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::Elasticsearch::Domain.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Elasticsearch::Domain.VPCOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
     */
    readonly vpcOptions?: CfnDomain.VPCOptionsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Elasticsearch::Domain`
 *
 * @cloudformationResource AWS::Elasticsearch::Domain
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Elasticsearch::Domain";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute DomainEndpoint
     */
    readonly attrDomainEndpoint: string;
    /**
     * `AWS::Elasticsearch::Domain.AccessPolicies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-accesspolicies
     */
    accessPolicies: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedoptions
     */
    advancedOptions: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.AdvancedSecurityOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-advancedsecurityoptions
     */
    advancedSecurityOptions: CfnDomain.AdvancedSecurityOptionsInputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.CognitoOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-cognitooptions
     */
    cognitoOptions: CfnDomain.CognitoOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.DomainEndpointOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainendpointoptions
     */
    domainEndpointOptions: CfnDomain.DomainEndpointOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-domainname
     */
    domainName: string | undefined;
    /**
     * `AWS::Elasticsearch::Domain.EBSOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-ebsoptions
     */
    ebsOptions: CfnDomain.EBSOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchClusterConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchclusterconfig
     */
    elasticsearchClusterConfig: CfnDomain.ElasticsearchClusterConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.ElasticsearchVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-elasticsearchversion
     */
    elasticsearchVersion: string | undefined;
    /**
     * `AWS::Elasticsearch::Domain.EncryptionAtRestOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-encryptionatrestoptions
     */
    encryptionAtRestOptions: CfnDomain.EncryptionAtRestOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.LogPublishingOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-logpublishingoptions
     */
    logPublishingOptions: {
        [key: string]: (CfnDomain.LogPublishingOptionProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.NodeToNodeEncryptionOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions
     */
    nodeToNodeEncryptionOptions: CfnDomain.NodeToNodeEncryptionOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.SnapshotOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-snapshotoptions
     */
    snapshotOptions: CfnDomain.SnapshotOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Elasticsearch::Domain.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Elasticsearch::Domain.VPCOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticsearch-domain.html#cfn-elasticsearch-domain-vpcoptions
     */
    vpcOptions: CfnDomain.VPCOptionsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Elasticsearch::Domain`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDomainProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html
     */
    interface AdvancedSecurityOptionsInputProperty {
        /**
         * `CfnDomain.AdvancedSecurityOptionsInputProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.AdvancedSecurityOptionsInputProperty.InternalUserDatabaseEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-internaluserdatabaseenabled
         */
        readonly internalUserDatabaseEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.AdvancedSecurityOptionsInputProperty.MasterUserOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-advancedsecurityoptionsinput.html#cfn-elasticsearch-domain-advancedsecurityoptionsinput-masteruseroptions
         */
        readonly masterUserOptions?: CfnDomain.MasterUserOptionsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html
     */
    interface CognitoOptionsProperty {
        /**
         * `CfnDomain.CognitoOptionsProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.CognitoOptionsProperty.IdentityPoolId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-identitypoolid
         */
        readonly identityPoolId?: string;
        /**
         * `CfnDomain.CognitoOptionsProperty.RoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnDomain.CognitoOptionsProperty.UserPoolId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-cognitooptions.html#cfn-elasticsearch-domain-cognitooptions-userpoolid
         */
        readonly userPoolId?: string;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html
     */
    interface DomainEndpointOptionsProperty {
        /**
         * `CfnDomain.DomainEndpointOptionsProperty.EnforceHTTPS`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-enforcehttps
         */
        readonly enforceHttps?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.DomainEndpointOptionsProperty.TLSSecurityPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-domainendpointoptions.html#cfn-elasticsearch-domain-domainendpointoptions-tlssecuritypolicy
         */
        readonly tlsSecurityPolicy?: string;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html
     */
    interface EBSOptionsProperty {
        /**
         * `CfnDomain.EBSOptionsProperty.EBSEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-ebsenabled
         */
        readonly ebsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.EBSOptionsProperty.Iops`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-iops
         */
        readonly iops?: number;
        /**
         * `CfnDomain.EBSOptionsProperty.VolumeSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnDomain.EBSOptionsProperty.VolumeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-ebsoptions.html#cfn-elasticsearch-domain-ebsoptions-volumetype
         */
        readonly volumeType?: string;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html
     */
    interface ElasticsearchClusterConfigProperty {
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmastercount
         */
        readonly dedicatedMasterCount?: number;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmasterenabled
         */
        readonly dedicatedMasterEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.DedicatedMasterType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-dedicatedmastertype
         */
        readonly dedicatedMasterType?: string;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.InstanceCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-instancecount
         */
        readonly instanceCount?: number;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-instnacetype
         */
        readonly instanceType?: string;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticsearchclusterconfig-zoneawarenessconfig
         */
        readonly zoneAwarenessConfig?: CfnDomain.ZoneAwarenessConfigProperty | cdk.IResolvable;
        /**
         * `CfnDomain.ElasticsearchClusterConfigProperty.ZoneAwarenessEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-elasticsearchclusterconfig.html#cfn-elasticsearch-domain-elasticseachclusterconfig-zoneawarenessenabled
         */
        readonly zoneAwarenessEnabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html
     */
    interface EncryptionAtRestOptionsProperty {
        /**
         * `CfnDomain.EncryptionAtRestOptionsProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDomain.EncryptionAtRestOptionsProperty.KmsKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-encryptionatrestoptions.html#cfn-elasticsearch-domain-encryptionatrestoptions-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html
     */
    interface LogPublishingOptionProperty {
        /**
         * `CfnDomain.LogPublishingOptionProperty.CloudWatchLogsLogGroupArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-cloudwatchlogsloggrouparn
         */
        readonly cloudWatchLogsLogGroupArn?: string;
        /**
         * `CfnDomain.LogPublishingOptionProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-logpublishingoption.html#cfn-elasticsearch-domain-logpublishingoption-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html
     */
    interface MasterUserOptionsProperty {
        /**
         * `CfnDomain.MasterUserOptionsProperty.MasterUserARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserarn
         */
        readonly masterUserArn?: string;
        /**
         * `CfnDomain.MasterUserOptionsProperty.MasterUserName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masterusername
         */
        readonly masterUserName?: string;
        /**
         * `CfnDomain.MasterUserOptionsProperty.MasterUserPassword`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-masteruseroptions.html#cfn-elasticsearch-domain-masteruseroptions-masteruserpassword
         */
        readonly masterUserPassword?: string;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html
     */
    interface NodeToNodeEncryptionOptionsProperty {
        /**
         * `CfnDomain.NodeToNodeEncryptionOptionsProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-nodetonodeencryptionoptions.html#cfn-elasticsearch-domain-nodetonodeencryptionoptions-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html
     */
    interface SnapshotOptionsProperty {
        /**
         * `CfnDomain.SnapshotOptionsProperty.AutomatedSnapshotStartHour`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-snapshotoptions.html#cfn-elasticsearch-domain-snapshotoptions-automatedsnapshotstarthour
         */
        readonly automatedSnapshotStartHour?: number;
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html
     */
    interface VPCOptionsProperty {
        /**
         * `CfnDomain.VPCOptionsProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnDomain.VPCOptionsProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-vpcoptions.html#cfn-elasticsearch-domain-vpcoptions-subnetids
         */
        readonly subnetIds?: string[];
    }
}
export declare namespace CfnDomain {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html
     */
    interface ZoneAwarenessConfigProperty {
        /**
         * `CfnDomain.ZoneAwarenessConfigProperty.AvailabilityZoneCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticsearch-domain-zoneawarenessconfig.html#cfn-elasticsearch-domain-zoneawarenessconfig-availabilityzonecount
         */
        readonly availabilityZoneCount?: number;
    }
}
