"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTargetGroupBase = void 0;
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Base internal class for existing target groups
 */
class ImportedTargetGroupBase extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Return an object to depend on the listeners added to this target group
         */
        this.loadBalancerAttached = new cdk.ConcreteDependable();
        this.targetGroupArn = props.targetGroupArn;
        this.loadBalancerArns = props.loadBalancerArns || cdk.Aws.NO_VALUE;
    }
}
exports.ImportedTargetGroupBase = ImportedTargetGroupBase;
//# sourceMappingURL=data:application/json;base64,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