"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TaskDefinition = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an EC2 cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class Ec2TaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromEc2TaskDefinitionArn(scope, id, ec2TaskDefinitionArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.taskDefinitionArn = ec2TaskDefinitionArn;
                this.compatibility = task_definition_1.Compatibility.EC2;
                this.isEc2Compatible = true;
                this.isFargateCompatible = false;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EC2,
            placementConstraints: props.placementConstraints,
            ipcMode: props.ipcMode,
            pidMode: props.pidMode,
        });
    }
}
exports.Ec2TaskDefinition = Ec2TaskDefinition;
//# sourceMappingURL=data:application/json;base64,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