"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DateTimeAttribute = exports.BooleanAttribute = exports.NumberAttribute = exports.StringAttribute = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * The String custom attribute type.
 */
class StringAttribute {
    constructor(props = {}) {
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
/**
 * The Number custom attribute type.
 */
class NumberAttribute {
    constructor(props = {}) {
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
/**
 * The Boolean custom attribute type.
 */
class BooleanAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
/**
 * The DateTime custom attribute type.
 */
class DateTimeAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
//# sourceMappingURL=data:application/json;base64,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