import * as codepipeline from "../../../aws-codepipeline";
import { Construct } from "../../../core";
import { Action } from '../action';
/**
 * Construction properties for {@link BitBucketSourceAction}.
 *
 * @experimental
 */
export interface BitBucketSourceActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The output artifact that this action produces.
     * Can be used as input for further pipeline actions.
     */
    readonly output: codepipeline.Artifact;
    /**
     * The ARN of the CodeStar Connection created in the AWS console
     * that has permissions to access this BitBucket repository.
     *
     * @example 'arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh'
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html
     */
    readonly connectionArn: string;
    /**
     * The owning user or organization of the repository.
     *
     * @example 'aws'
     */
    readonly owner: string;
    /**
     * The name of the repository.
     *
     * @example 'aws-cdk'
     */
    readonly repo: string;
    /**
     * The branch to build.
     *
     * @default 'master'
     */
    readonly branch?: string;
    /**
     * Whether the output should be the contents of the repository
     * (which is the default),
     * or a link that allows CodeBuild to clone the repository before building.
     *
     * **Note**: if this option is true,
     * then only CodeBuild actions can use the resulting {@link output}.
     *
     * @default false
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config
     */
    readonly codeBuildCloneOutput?: boolean;
}
/**
 * A CodePipeline source action for BitBucket.
 *
 * @experimental
 */
export declare class BitBucketSourceAction extends Action {
    private readonly props;
    constructor(props: BitBucketSourceActionProps);
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
