"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDeploymentConfig = void 0;
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(_scope, _id, props) {
        return deploymentConfig(props.deploymentConfigName);
    }
}
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
LambdaDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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