"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextWidget = void 0;
const widget_1 = require("./widget");
/**
 * A dashboard widget that displays MarkDown
 */
class TextWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 2);
        this.markdown = props.markdown;
    }
    position(x, y) {
        this.x = x;
        this.y = y;
    }
    toJson() {
        return [{
                type: 'text',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    markdown: this.markdown,
                },
            }];
    }
}
exports.TextWidget = TextWidget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGV4dC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRleHQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQTBDO0FBc0IxQzs7R0FFRztBQUNILE1BQWEsVUFBVyxTQUFRLHVCQUFjO0lBRTFDLFlBQVksS0FBc0I7UUFDOUIsS0FBSyxDQUFDLEtBQUssQ0FBQyxLQUFLLElBQUksQ0FBQyxFQUFFLEtBQUssQ0FBQyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDM0MsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO0lBQ25DLENBQUM7SUFDTSxRQUFRLENBQUMsQ0FBUyxFQUFFLENBQVM7UUFDaEMsSUFBSSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDWCxJQUFJLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUNmLENBQUM7SUFDTSxNQUFNO1FBQ1QsT0FBTyxDQUFDO2dCQUNBLElBQUksRUFBRSxNQUFNO2dCQUNaLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztnQkFDakIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO2dCQUNuQixDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7Z0JBQ1QsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFDO2dCQUNULFVBQVUsRUFBRTtvQkFDUixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7aUJBQzFCO2FBQ0osQ0FBQyxDQUFDO0lBQ1gsQ0FBQztDQUNKO0FBdEJELGdDQXNCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbmNyZXRlV2lkZ2V0IH0gZnJvbSAnLi93aWRnZXQnO1xuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIFRleHQgd2lkZ2V0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVGV4dFdpZGdldFByb3BzIHtcbiAgICAvKipcbiAgICAgKiBUaGUgdGV4dCB0byBkaXNwbGF5LCBpbiBNYXJrRG93biBmb3JtYXRcbiAgICAgKi9cbiAgICByZWFkb25seSBtYXJrZG93bjogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFdpZHRoIG9mIHRoZSB3aWRnZXQsIGluIGEgZ3JpZCBvZiAyNCB1bml0cyB3aWRlXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCA2XG4gICAgICovXG4gICAgcmVhZG9ubHkgd2lkdGg/OiBudW1iZXI7XG4gICAgLyoqXG4gICAgICogSGVpZ2h0IG9mIHRoZSB3aWRnZXRcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IDJcbiAgICAgKi9cbiAgICByZWFkb25seSBoZWlnaHQ/OiBudW1iZXI7XG59XG4vKipcbiAqIEEgZGFzaGJvYXJkIHdpZGdldCB0aGF0IGRpc3BsYXlzIE1hcmtEb3duXG4gKi9cbmV4cG9ydCBjbGFzcyBUZXh0V2lkZ2V0IGV4dGVuZHMgQ29uY3JldGVXaWRnZXQge1xuICAgIHByaXZhdGUgcmVhZG9ubHkgbWFya2Rvd246IHN0cmluZztcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogVGV4dFdpZGdldFByb3BzKSB7XG4gICAgICAgIHN1cGVyKHByb3BzLndpZHRoIHx8IDYsIHByb3BzLmhlaWdodCB8fCAyKTtcbiAgICAgICAgdGhpcy5tYXJrZG93biA9IHByb3BzLm1hcmtkb3duO1xuICAgIH1cbiAgICBwdWJsaWMgcG9zaXRpb24oeDogbnVtYmVyLCB5OiBudW1iZXIpOiB2b2lkIHtcbiAgICAgICAgdGhpcy54ID0geDtcbiAgICAgICAgdGhpcy55ID0geTtcbiAgICB9XG4gICAgcHVibGljIHRvSnNvbigpOiBhbnlbXSB7XG4gICAgICAgIHJldHVybiBbe1xuICAgICAgICAgICAgICAgIHR5cGU6ICd0ZXh0JyxcbiAgICAgICAgICAgICAgICB3aWR0aDogdGhpcy53aWR0aCxcbiAgICAgICAgICAgICAgICBoZWlnaHQ6IHRoaXMuaGVpZ2h0LFxuICAgICAgICAgICAgICAgIHg6IHRoaXMueCxcbiAgICAgICAgICAgICAgICB5OiB0aGlzLnksXG4gICAgICAgICAgICAgICAgcHJvcGVydGllczoge1xuICAgICAgICAgICAgICAgICAgICBtYXJrZG93bjogdGhpcy5tYXJrZG93bixcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfV07XG4gICAgfVxufVxuIl19