"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmBase = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * The base class for Alarm and CompositeAlarm resources.
 */
class AlarmBase extends core_1.Resource {
    /**
     * AlarmRule indicating ALARM state for Alarm.
     */
    renderAlarmRule() {
        return `ALARM(${this.alarmArn})`;
    }
    /**
     * Trigger this action if the alarm fires
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     */
    addAlarmAction(...actions) {
        if (this.alarmActionArns === undefined) {
            this.alarmActionArns = [];
        }
        this.alarmActionArns.push(...actions.map(a => a.bind(this, this).alarmActionArn));
    }
    /**
     * Trigger this action if there is insufficient data to evaluate the alarm
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     */
    addInsufficientDataAction(...actions) {
        if (this.insufficientDataActionArns === undefined) {
            this.insufficientDataActionArns = [];
        }
        this.insufficientDataActionArns.push(...actions.map(a => a.bind(this, this).alarmActionArn));
    }
    /**
     * Trigger this action if the alarm returns from breaching state into ok state
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     */
    addOkAction(...actions) {
        if (this.okActionArns === undefined) {
            this.okActionArns = [];
        }
        this.okActionArns.push(...actions.map(a => a.bind(this, this).alarmActionArn));
    }
}
exports.AlarmBase = AlarmBase;
//# sourceMappingURL=data:application/json;base64,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